package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  Ipv6Address,
  IpAddress,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class Instance(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    blueprintId: Optional[NonEmptyString] = Optional.Absent,
    blueprintName: Optional[NonEmptyString] = Optional.Absent,
    bundleId: Optional[NonEmptyString] = Optional.Absent,
    addOns: Optional[Iterable[zio.aws.lightsail.model.AddOn]] = Optional.Absent,
    isStaticIp: Optional[Boolean] = Optional.Absent,
    privateIpAddress: Optional[IpAddress] = Optional.Absent,
    publicIpAddress: Optional[IpAddress] = Optional.Absent,
    ipv6Addresses: Optional[Iterable[Ipv6Address]] = Optional.Absent,
    ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType] =
      Optional.Absent,
    hardware: Optional[zio.aws.lightsail.model.InstanceHardware] =
      Optional.Absent,
    networking: Optional[zio.aws.lightsail.model.InstanceNetworking] =
      Optional.Absent,
    state: Optional[zio.aws.lightsail.model.InstanceState] = Optional.Absent,
    username: Optional[NonEmptyString] = Optional.Absent,
    sshKeyName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Instance
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        blueprintId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.blueprintId)
      .optionallyWith(
        blueprintName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.blueprintName)
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(isStaticIp.map(value => value: java.lang.Boolean))(
        _.isStaticIp
      )
      .optionallyWith(
        privateIpAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.privateIpAddress)
      .optionallyWith(
        publicIpAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.publicIpAddress)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            Ipv6Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware)
      .optionallyWith(networking.map(value => value.buildAwsValue()))(
        _.networking
      )
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        username.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        sshKeyName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.sshKeyName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Instance.ReadOnly =
    zio.aws.lightsail.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Instance =
      zio.aws.lightsail.model.Instance(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blueprintId.map(value => value),
        blueprintName.map(value => value),
        bundleId.map(value => value),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isStaticIp.map(value => value),
        privateIpAddress.map(value => value),
        publicIpAddress.map(value => value),
        ipv6Addresses.map(value => value),
        ipAddressType.map(value => value),
        hardware.map(value => value.asEditable),
        networking.map(value => value.asEditable),
        state.map(value => value.asEditable),
        username.map(value => value),
        sshKeyName.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def blueprintId: Optional[NonEmptyString]
    def blueprintName: Optional[NonEmptyString]
    def bundleId: Optional[NonEmptyString]
    def addOns: Optional[List[zio.aws.lightsail.model.AddOn.ReadOnly]]
    def isStaticIp: Optional[Boolean]
    def privateIpAddress: Optional[IpAddress]
    def publicIpAddress: Optional[IpAddress]
    def ipv6Addresses: Optional[List[Ipv6Address]]
    def ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType]
    def hardware: Optional[zio.aws.lightsail.model.InstanceHardware.ReadOnly]
    def networking
        : Optional[zio.aws.lightsail.model.InstanceNetworking.ReadOnly]
    def state: Optional[zio.aws.lightsail.model.InstanceState.ReadOnly]
    def username: Optional[NonEmptyString]
    def sshKeyName: Optional[ResourceName]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintId", blueprintId)
    def getBlueprintName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintName", blueprintName)
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getAddOns
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      AwsError.unwrapOptionField("addOns", addOns)
    def getIsStaticIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isStaticIp", isStaticIp)
    def getPrivateIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getIpv6Addresses: ZIO[Any, AwsError, List[Ipv6Address]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getHardware: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceHardware.ReadOnly
    ] = AwsError.unwrapOptionField("hardware", hardware)
    def getNetworking: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceNetworking.ReadOnly
    ] = AwsError.unwrapOptionField("networking", networking)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("username", username)
    def getSshKeyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sshKeyName", sshKeyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Instance
  ) extends zio.aws.lightsail.model.Instance.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val blueprintId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprintId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val blueprintName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprintName())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val bundleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val addOns
        : Optional[List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOn.wrap(item)
          }.toList
        )
    override val isStaticIp: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isStaticIp())
      .map(value => value: Boolean)
    override val privateIpAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val publicIpAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIpAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val ipv6Addresses: Optional[List[Ipv6Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.primitives.Ipv6Address(item)
          }.toList
        )
    override val ipAddressType
        : Optional[zio.aws.lightsail.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val hardware
        : Optional[zio.aws.lightsail.model.InstanceHardware.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hardware())
        .map(value => zio.aws.lightsail.model.InstanceHardware.wrap(value))
    override val networking
        : Optional[zio.aws.lightsail.model.InstanceNetworking.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networking())
        .map(value => zio.aws.lightsail.model.InstanceNetworking.wrap(value))
    override val state
        : Optional[zio.aws.lightsail.model.InstanceState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.InstanceState.wrap(value))
    override val username: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val sshKeyName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.sshKeyName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Instance
  ): zio.aws.lightsail.model.Instance.ReadOnly = new Wrapper(impl)
}
