package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait InstancePlatform {
  def unwrap: software.amazon.awssdk.services.lightsail.model.InstancePlatform
}
object InstancePlatform {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstancePlatform
  ): zio.aws.lightsail.model.InstancePlatform = value match {
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.LINUX_UNIX =>
      val r = LINUX_UNIX
      r
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.WINDOWS =>
      val r = WINDOWS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.InstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstancePlatform =
      software.amazon.awssdk.services.lightsail.model.InstancePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object LINUX_UNIX extends zio.aws.lightsail.model.InstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstancePlatform =
      software.amazon.awssdk.services.lightsail.model.InstancePlatform.LINUX_UNIX
  }
  case object WINDOWS extends zio.aws.lightsail.model.InstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstancePlatform =
      software.amazon.awssdk.services.lightsail.model.InstancePlatform.WINDOWS
  }
}
