package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  Port,
  Integer,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class LoadBalancer(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    dnsName: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.LoadBalancerState] =
      Optional.Absent,
    protocol: Optional[zio.aws.lightsail.model.LoadBalancerProtocol] =
      Optional.Absent,
    publicPorts: Optional[Iterable[Port]] = Optional.Absent,
    healthCheckPath: Optional[NonEmptyString] = Optional.Absent,
    instancePort: Optional[Integer] = Optional.Absent,
    instanceHealthSummary: Optional[
      Iterable[zio.aws.lightsail.model.InstanceHealthSummary]
    ] = Optional.Absent,
    tlsCertificateSummaries: Optional[
      Iterable[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary]
    ] = Optional.Absent,
    configurationOptions: Optional[
      Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]
    ] = Optional.Absent,
    ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType] =
      Optional.Absent,
    httpsRedirectionEnabled: Optional[Boolean] = Optional.Absent,
    tlsPolicyName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancer
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dnsName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        publicPorts.map(value =>
          value.map { item =>
            Port.unwrap(item): java.lang.Integer
          }.asJavaCollection
        )
      )(_.publicPorts)
      .optionallyWith(
        healthCheckPath.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.healthCheckPath)
      .optionallyWith(instancePort.map(value => value: java.lang.Integer))(
        _.instancePort
      )
      .optionallyWith(
        instanceHealthSummary.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceHealthSummary)
      .optionallyWith(
        tlsCertificateSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsCertificateSummaries)
      .optionallyWith(
        configurationOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.configurationOptionsWithStrings)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        httpsRedirectionEnabled.map(value => value: java.lang.Boolean)
      )(_.httpsRedirectionEnabled)
      .optionallyWith(
        tlsPolicyName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.tlsPolicyName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LoadBalancer.ReadOnly =
    zio.aws.lightsail.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LoadBalancer =
      zio.aws.lightsail.model.LoadBalancer(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dnsName.map(value => value),
        state.map(value => value),
        protocol.map(value => value),
        publicPorts.map(value => value),
        healthCheckPath.map(value => value),
        instancePort.map(value => value),
        instanceHealthSummary.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tlsCertificateSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationOptions.map(value => value),
        ipAddressType.map(value => value),
        httpsRedirectionEnabled.map(value => value),
        tlsPolicyName.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def dnsName: Optional[NonEmptyString]
    def state: Optional[zio.aws.lightsail.model.LoadBalancerState]
    def protocol: Optional[zio.aws.lightsail.model.LoadBalancerProtocol]
    def publicPorts: Optional[List[Port]]
    def healthCheckPath: Optional[NonEmptyString]
    def instancePort: Optional[Integer]
    def instanceHealthSummary
        : Optional[List[zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly]]
    def tlsCertificateSummaries: Optional[
      List[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly]
    ]
    def configurationOptions: Optional[
      Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]
    ]
    def ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType]
    def httpsRedirectionEnabled: Optional[Boolean]
    def tlsPolicyName: Optional[ResourceName]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.LoadBalancerState] =
      AwsError.unwrapOptionField("state", state)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.LoadBalancerProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPublicPorts: ZIO[Any, AwsError, List[Port]] =
      AwsError.unwrapOptionField("publicPorts", publicPorts)
    def getHealthCheckPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPath)
    def getInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instancePort", instancePort)
    def getInstanceHealthSummary: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("instanceHealthSummary", instanceHealthSummary)
    def getTlsCertificateSummaries: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tlsCertificateSummaries",
      tlsCertificateSummaries
    )
    def getConfigurationOptions: ZIO[Any, AwsError, Map[
      zio.aws.lightsail.model.LoadBalancerAttributeName,
      String
    ]] =
      AwsError.unwrapOptionField("configurationOptions", configurationOptions)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getHttpsRedirectionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("httpsRedirectionEnabled", httpsRedirectionEnabled)
    def getTlsPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("tlsPolicyName", tlsPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ) extends zio.aws.lightsail.model.LoadBalancer.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val dnsName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val state: Optional[zio.aws.lightsail.model.LoadBalancerState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.LoadBalancerState.wrap(value))
    override val protocol
        : Optional[zio.aws.lightsail.model.LoadBalancerProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.lightsail.model.LoadBalancerProtocol.wrap(value))
    override val publicPorts: Optional[List[Port]] = zio.aws.core.internal
      .optionalFromNullable(impl.publicPorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.Port(item)
        }.toList
      )
    override val healthCheckPath: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckPath())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val instancePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancePort())
      .map(value => value: Integer)
    override val instanceHealthSummary: Optional[
      List[zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceHealthSummary())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.InstanceHealthSummary.wrap(item)
        }.toList
      )
    override val tlsCertificateSummaries: Optional[
      List[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsCertificateSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.wrap(item)
        }.toList
      )
    override val configurationOptions: Optional[
      Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.LoadBalancerAttributeName
              .wrap(key) -> (value: String)
          })
          .toMap
      )
    override val ipAddressType
        : Optional[zio.aws.lightsail.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val httpsRedirectionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpsRedirectionEnabled())
        .map(value => value: Boolean)
    override val tlsPolicyName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsPolicyName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ): zio.aws.lightsail.model.LoadBalancer.ReadOnly = new Wrapper(impl)
}
