package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  DomainName,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class LoadBalancerTlsCertificate(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    loadBalancerName: Optional[ResourceName] = Optional.Absent,
    isAttached: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus] =
      Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    domainValidationRecords: Optional[Iterable[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
    ]] = Optional.Absent,
    failureReason: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = Optional.Absent,
    issuedAt: Optional[IsoDate] = Optional.Absent,
    issuer: Optional[NonEmptyString] = Optional.Absent,
    keyAlgorithm: Optional[NonEmptyString] = Optional.Absent,
    notAfter: Optional[IsoDate] = Optional.Absent,
    notBefore: Optional[IsoDate] = Optional.Absent,
    renewalSummary: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
    ] = Optional.Absent,
    revocationReason: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = Optional.Absent,
    revokedAt: Optional[IsoDate] = Optional.Absent,
    serial: Optional[NonEmptyString] = Optional.Absent,
    signatureAlgorithm: Optional[NonEmptyString] = Optional.Absent,
    subject: Optional[NonEmptyString] = Optional.Absent,
    subjectAlternativeNames: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate = {
    import LoadBalancerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        loadBalancerName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(issuedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(
        issuer.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        keyAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.keyAlgorithm)
      .optionallyWith(notAfter.map(value => IsoDate.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(notBefore.map(value => IsoDate.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(revocationReason.map(value => value.unwrap))(
        _.revocationReason
      )
      .optionallyWith(revokedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.revokedAt
      )
      .optionallyWith(
        serial.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serial)
      .optionallyWith(
        signatureAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.signatureAlgorithm)
      .optionallyWith(
        subject.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificate.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LoadBalancerTlsCertificate =
      zio.aws.lightsail.model.LoadBalancerTlsCertificate(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancerName.map(value => value),
        isAttached.map(value => value),
        status.map(value => value),
        domainName.map(value => value),
        domainValidationRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReason.map(value => value),
        issuedAt.map(value => value),
        issuer.map(value => value),
        keyAlgorithm.map(value => value),
        notAfter.map(value => value),
        notBefore.map(value => value),
        renewalSummary.map(value => value.asEditable),
        revocationReason.map(value => value),
        revokedAt.map(value => value),
        serial.map(value => value),
        signatureAlgorithm.map(value => value),
        subject.map(value => value),
        subjectAlternativeNames.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def loadBalancerName: Optional[ResourceName]
    def isAttached: Optional[Boolean]
    def status
        : Optional[zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus]
    def domainName: Optional[DomainName]
    def domainValidationRecords: Optional[List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]]
    def failureReason: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ]
    def issuedAt: Optional[IsoDate]
    def issuer: Optional[NonEmptyString]
    def keyAlgorithm: Optional[NonEmptyString]
    def notAfter: Optional[IsoDate]
    def notBefore: Optional[IsoDate]
    def renewalSummary: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ]
    def revocationReason: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ]
    def revokedAt: Optional[IsoDate]
    def serial: Optional[NonEmptyString]
    def signatureAlgorithm: Optional[NonEmptyString]
    def subject: Optional[NonEmptyString]
    def subjectAlternativeNames: Optional[List[String]]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLoadBalancerName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainValidationRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecords
    )
    def getFailureReason: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = AwsError.unwrapOptionField("failureReason", failureReason)
    def getIssuedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getIssuer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getKeyAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getNotAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getRenewalSummary: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ] = AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getRevocationReason: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = AwsError.unwrapOptionField("revocationReason", revocationReason)
    def getRevokedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
    def getSerial: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serial", serial)
    def getSignatureAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getSubject: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subject", subject)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("subjectAlternativeNames", subjectAlternativeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val loadBalancerName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAttached())
      .map(value => value: Boolean)
    override val status
        : Optional[zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateStatus.wrap(value)
        )
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val domainValidationRecords: Optional[List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
            .wrap(item)
        }.toList
      )
    override val failureReason: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateFailureReason
          .wrap(value)
      )
    override val issuedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.issuedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val issuer: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.issuer())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val keyAlgorithm: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyAlgorithm())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val notAfter: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val notBefore: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val renewalSummary: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.renewalSummary())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
          .wrap(value)
      )
    override val revocationReason: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.revocationReason())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
          .wrap(value)
      )
    override val revokedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.revokedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val serial: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serial())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val signatureAlgorithm: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signatureAlgorithm())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val subject: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val subjectAlternativeNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subjectAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly = new Wrapper(
    impl
  )
}
