package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoadBalancerTlsCertificateDomainValidationOption(
    domainName: Optional[DomainName] = Optional.Absent,
    validationStatus: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption = {
    import LoadBalancerTlsCertificateDomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption =
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption(
        domainName.map(value => value),
        validationStatus.map(value => value)
      )
    def domainName: Optional[DomainName]
    def validationStatus: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getValidationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val validationStatus: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationStatus())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly =
    new Wrapper(impl)
}
