package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoadBalancerTlsPolicy(
    name: Optional[ResourceName] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    protocols: Optional[Iterable[String]] = Optional.Absent,
    ciphers: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicy = {
    import LoadBalancerTlsPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicy
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.protocols)
      .optionallyWith(
        ciphers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ciphers)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LoadBalancerTlsPolicy.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsPolicy.wrap(buildAwsValue())
}
object LoadBalancerTlsPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LoadBalancerTlsPolicy =
      zio.aws.lightsail.model.LoadBalancerTlsPolicy(
        name.map(value => value),
        isDefault.map(value => value),
        description.map(value => value),
        protocols.map(value => value),
        ciphers.map(value => value)
      )
    def name: Optional[ResourceName]
    def isDefault: Optional[Boolean]
    def description: Optional[String]
    def protocols: Optional[List[String]]
    def ciphers: Optional[List[String]]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getProtocols: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getCiphers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ciphers", ciphers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicy
  ) extends zio.aws.lightsail.model.LoadBalancerTlsPolicy.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val protocols: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ciphers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ciphers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicy
  ): zio.aws.lightsail.model.LoadBalancerTlsPolicy.ReadOnly = new Wrapper(impl)
}
