package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class MetricDatapoint(
    average: Optional[Double] = Optional.Absent,
    maximum: Optional[Double] = Optional.Absent,
    minimum: Optional[Double] = Optional.Absent,
    sampleCount: Optional[Double] = Optional.Absent,
    sum: Optional[Double] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent,
    unit: Optional[zio.aws.lightsail.model.MetricUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MetricDatapoint = {
    import MetricDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint
      .builder()
      .optionallyWith(average.map(value => value: java.lang.Double))(_.average)
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .optionallyWith(sampleCount.map(value => value: java.lang.Double))(
        _.sampleCount
      )
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.MetricDatapoint.ReadOnly =
    zio.aws.lightsail.model.MetricDatapoint.wrap(buildAwsValue())
}
object MetricDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.MetricDatapoint =
      zio.aws.lightsail.model.MetricDatapoint(
        average.map(value => value),
        maximum.map(value => value),
        minimum.map(value => value),
        sampleCount.map(value => value),
        sum.map(value => value),
        timestamp.map(value => value),
        unit.map(value => value)
      )
    def average: Optional[Double]
    def maximum: Optional[Double]
    def minimum: Optional[Double]
    def sampleCount: Optional[Double]
    def sum: Optional[Double]
    def timestamp: Optional[Timestamp]
    def unit: Optional[zio.aws.lightsail.model.MetricUnit]
    def getAverage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("average", average)
    def getMaximum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getMinimum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getSampleCount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sampleCount", sampleCount)
    def getSum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sum", sum)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getUnit: ZIO[Any, AwsError, zio.aws.lightsail.model.MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ) extends zio.aws.lightsail.model.MetricDatapoint.ReadOnly {
    override val average: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.average())
      .map(value => value: Double)
    override val maximum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => value: Double)
    override val minimum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.minimum())
      .map(value => value: Double)
    override val sampleCount: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleCount())
      .map(value => value: Double)
    override val sum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value => value: Double)
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.lightsail.model.primitives.Timestamp(value))
    override val unit: Optional[zio.aws.lightsail.model.MetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.lightsail.model.MetricUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ): zio.aws.lightsail.model.MetricDatapoint.ReadOnly = new Wrapper(impl)
}
