package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait OperationStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.OperationStatus
}
object OperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.OperationStatus
  ): zio.aws.lightsail.model.OperationStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.OperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.OperationStatus.NOT_STARTED =>
      val r = NotStarted
      r
    case software.amazon.awssdk.services.lightsail.model.OperationStatus.STARTED =>
      val r = Started
      r
    case software.amazon.awssdk.services.lightsail.model.OperationStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lightsail.model.OperationStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.lightsail.model.OperationStatus.SUCCEEDED =>
      val r = Succeeded
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OperationStatus =
      software.amazon.awssdk.services.lightsail.model.OperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotStarted extends zio.aws.lightsail.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OperationStatus =
      software.amazon.awssdk.services.lightsail.model.OperationStatus.NOT_STARTED
  }
  case object Started extends zio.aws.lightsail.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OperationStatus =
      software.amazon.awssdk.services.lightsail.model.OperationStatus.STARTED
  }
  case object Failed extends zio.aws.lightsail.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OperationStatus =
      software.amazon.awssdk.services.lightsail.model.OperationStatus.FAILED
  }
  case object Completed extends zio.aws.lightsail.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OperationStatus =
      software.amazon.awssdk.services.lightsail.model.OperationStatus.COMPLETED
  }
  case object Succeeded extends zio.aws.lightsail.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OperationStatus =
      software.amazon.awssdk.services.lightsail.model.OperationStatus.SUCCEEDED
  }
}
