package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait OriginProtocolPolicyEnum {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum
}
object OriginProtocolPolicyEnum {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum
  ): zio.aws.lightsail.model.OriginProtocolPolicyEnum = value match {
    case software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTP_ONLY =>
      val r = `http-only`
      r
    case software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTPS_ONLY =>
      val r = `https-only`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.OriginProtocolPolicyEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum =
      software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object `http-only`
      extends zio.aws.lightsail.model.OriginProtocolPolicyEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum =
      software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTP_ONLY
  }
  case object `https-only`
      extends zio.aws.lightsail.model.OriginProtocolPolicyEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum =
      software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTPS_ONLY
  }
}
