package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class PendingMaintenanceAction(
    action: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    currentApplyDate: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
      .builder()
      .optionallyWith(
        action.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        currentApplyDate.map(value => IsoDate.unwrap(value): Instant)
      )(_.currentApplyDate)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly =
    zio.aws.lightsail.model.PendingMaintenanceAction.wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PendingMaintenanceAction =
      zio.aws.lightsail.model.PendingMaintenanceAction(
        action.map(value => value),
        description.map(value => value),
        currentApplyDate.map(value => value)
      )
    def action: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def currentApplyDate: Optional[IsoDate]
    def getAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("action", action)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCurrentApplyDate: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("currentApplyDate", currentApplyDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
  ) extends zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly {
    override val action: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val currentApplyDate: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.currentApplyDate())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction
  ): zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly = new Wrapper(
    impl
  )
}
