package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrivateRegistryAccess(
    ecrImagePullerRole: Optional[
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRole
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccess = {
    import PrivateRegistryAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccess
      .builder()
      .optionallyWith(ecrImagePullerRole.map(value => value.buildAwsValue()))(
        _.ecrImagePullerRole
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.PrivateRegistryAccess.ReadOnly =
    zio.aws.lightsail.model.PrivateRegistryAccess.wrap(buildAwsValue())
}
object PrivateRegistryAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PrivateRegistryAccess =
      zio.aws.lightsail.model.PrivateRegistryAccess(
        ecrImagePullerRole.map(value => value.asEditable)
      )
    def ecrImagePullerRole: Optional[
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.ReadOnly
    ]
    def getEcrImagePullerRole: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.ReadOnly
    ] = AwsError.unwrapOptionField("ecrImagePullerRole", ecrImagePullerRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccess
  ) extends zio.aws.lightsail.model.PrivateRegistryAccess.ReadOnly {
    override val ecrImagePullerRole: Optional[
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrImagePullerRole())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccess
  ): zio.aws.lightsail.model.PrivateRegistryAccess.ReadOnly = new Wrapper(impl)
}
