package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrivateRegistryAccessRequest(
    ecrImagePullerRole: Optional[
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccessRequest = {
    import PrivateRegistryAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccessRequest
      .builder()
      .optionallyWith(ecrImagePullerRole.map(value => value.buildAwsValue()))(
        _.ecrImagePullerRole
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.PrivateRegistryAccessRequest.ReadOnly =
    zio.aws.lightsail.model.PrivateRegistryAccessRequest.wrap(buildAwsValue())
}
object PrivateRegistryAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PrivateRegistryAccessRequest =
      zio.aws.lightsail.model.PrivateRegistryAccessRequest(
        ecrImagePullerRole.map(value => value.asEditable)
      )
    def ecrImagePullerRole: Optional[
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest.ReadOnly
    ]
    def getEcrImagePullerRole: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest.ReadOnly
    ] = AwsError.unwrapOptionField("ecrImagePullerRole", ecrImagePullerRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccessRequest
  ) extends zio.aws.lightsail.model.PrivateRegistryAccessRequest.ReadOnly {
    override val ecrImagePullerRole: Optional[
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrImagePullerRole())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PrivateRegistryAccessRequest
  ): zio.aws.lightsail.model.PrivateRegistryAccessRequest.ReadOnly =
    new Wrapper(impl)
}
