package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutInstancePublicPortsRequest(
    portInfos: Iterable[zio.aws.lightsail.model.PortInfo],
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest = {
    import PutInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
      .builder()
      .portInfos(portInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.PutInstancePublicPortsRequest.ReadOnly =
    zio.aws.lightsail.model.PutInstancePublicPortsRequest.wrap(buildAwsValue())
}
object PutInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PutInstancePublicPortsRequest =
      zio.aws.lightsail.model.PutInstancePublicPortsRequest(
        portInfos.map { item =>
          item.asEditable
        },
        instanceName
      )
    def portInfos: List[zio.aws.lightsail.model.PortInfo.ReadOnly]
    def instanceName: ResourceName
    def getPortInfos
        : ZIO[Any, Nothing, List[zio.aws.lightsail.model.PortInfo.ReadOnly]] =
      ZIO.succeed(portInfos)
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
  ) extends zio.aws.lightsail.model.PutInstancePublicPortsRequest.ReadOnly {
    override val portInfos: List[zio.aws.lightsail.model.PortInfo.ReadOnly] =
      impl
        .portInfos()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.PortInfo.wrap(item)
        }
        .toList
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest
  ): zio.aws.lightsail.model.PutInstancePublicPortsRequest.ReadOnly =
    new Wrapper(impl)
}
