package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterContainerImageResponse(
    containerImage: Optional[zio.aws.lightsail.model.ContainerImage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse = {
    import RegisterContainerImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
      .builder()
      .optionallyWith(containerImage.map(value => value.buildAwsValue()))(
        _.containerImage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly =
    zio.aws.lightsail.model.RegisterContainerImageResponse.wrap(buildAwsValue())
}
object RegisterContainerImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RegisterContainerImageResponse =
      zio.aws.lightsail.model.RegisterContainerImageResponse(
        containerImage.map(value => value.asEditable)
      )
    def containerImage
        : Optional[zio.aws.lightsail.model.ContainerImage.ReadOnly]
    def getContainerImage
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContainerImage.ReadOnly] =
      AwsError.unwrapOptionField("containerImage", containerImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ) extends zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly {
    override val containerImage
        : Optional[zio.aws.lightsail.model.ContainerImage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerImage())
        .map(value => zio.aws.lightsail.model.ContainerImage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ): zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly =
    new Wrapper(impl)
}
