package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RelationalDatabaseBlueprint(
    blueprintId: Optional[String] = Optional.Absent,
    engine: Optional[zio.aws.lightsail.model.RelationalDatabaseEngine] =
      Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    engineDescription: Optional[String] = Optional.Absent,
    engineVersionDescription: Optional[String] = Optional.Absent,
    isEngineDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint = {
    import RelationalDatabaseBlueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
      .builder()
      .optionallyWith(blueprintId.map(value => value: java.lang.String))(
        _.blueprintId
      )
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(engineDescription.map(value => value: java.lang.String))(
        _.engineDescription
      )
      .optionallyWith(
        engineVersionDescription.map(value => value: java.lang.String)
      )(_.engineVersionDescription)
      .optionallyWith(isEngineDefault.map(value => value: java.lang.Boolean))(
        _.isEngineDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseBlueprint.wrap(buildAwsValue())
}
object RelationalDatabaseBlueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseBlueprint =
      zio.aws.lightsail.model.RelationalDatabaseBlueprint(
        blueprintId.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        engineDescription.map(value => value),
        engineVersionDescription.map(value => value),
        isEngineDefault.map(value => value)
      )
    def blueprintId: Optional[String]
    def engine: Optional[zio.aws.lightsail.model.RelationalDatabaseEngine]
    def engineVersion: Optional[String]
    def engineDescription: Optional[String]
    def engineVersionDescription: Optional[String]
    def isEngineDefault: Optional[Boolean]
    def getBlueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blueprintId", blueprintId)
    def getEngine
        : ZIO[Any, AwsError, zio.aws.lightsail.model.RelationalDatabaseEngine] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineDescription", engineDescription)
    def getEngineVersionDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("engineVersionDescription", engineVersionDescription)
    def getIsEngineDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEngineDefault", isEngineDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ) extends zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly {
    override val blueprintId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprintId())
      .map(value => value: String)
    override val engine
        : Optional[zio.aws.lightsail.model.RelationalDatabaseEngine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value =>
          zio.aws.lightsail.model.RelationalDatabaseEngine.wrap(value)
        )
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val engineDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineDescription())
      .map(value => value: String)
    override val engineVersionDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersionDescription())
        .map(value => value: String)
    override val isEngineDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEngineDefault())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBlueprint
  ): zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly = new Wrapper(
    impl
  )
}
