package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, ResourceName}
import scala.jdk.CollectionConverters._
final case class RelationalDatabaseEvent(
    resource: Optional[ResourceName] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    eventCategories: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent = {
    import RelationalDatabaseEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
      .builder()
      .optionallyWith(
        resource.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resource)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseEvent.wrap(buildAwsValue())
}
object RelationalDatabaseEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseEvent =
      zio.aws.lightsail.model.RelationalDatabaseEvent(
        resource.map(value => value),
        createdAt.map(value => value),
        message.map(value => value),
        eventCategories.map(value => value)
      )
    def resource: Optional[ResourceName]
    def createdAt: Optional[IsoDate]
    def message: Optional[String]
    def eventCategories: Optional[List[String]]
    def getResource: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resource", resource)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ) extends zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly {
    override val resource: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val eventCategories: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ): zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly = new Wrapper(
    impl
  )
}
