package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait StatusType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.StatusType
}
object StatusType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.StatusType
  ): zio.aws.lightsail.model.StatusType = value match {
    case software.amazon.awssdk.services.lightsail.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.StatusType.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.lightsail.model.StatusType.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.StatusType =
      software.amazon.awssdk.services.lightsail.model.StatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.lightsail.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.StatusType =
      software.amazon.awssdk.services.lightsail.model.StatusType.ACTIVE
  }
  case object Inactive extends zio.aws.lightsail.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.StatusType =
      software.amazon.awssdk.services.lightsail.model.StatusType.INACTIVE
  }
}
