package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestAlarmResponse(
    operations: Optional[Iterable[zio.aws.lightsail.model.Operation]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.TestAlarmResponse = {
    import TestAlarmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TestAlarmResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.TestAlarmResponse.ReadOnly =
    zio.aws.lightsail.model.TestAlarmResponse.wrap(buildAwsValue())
}
object TestAlarmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.TestAlarmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.TestAlarmResponse =
      zio.aws.lightsail.model.TestAlarmResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operations: Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.TestAlarmResponse
  ) extends zio.aws.lightsail.model.TestAlarmResponse.ReadOnly {
    override val operations
        : Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Operation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.TestAlarmResponse
  ): zio.aws.lightsail.model.TestAlarmResponse.ReadOnly = new Wrapper(impl)
}
