package zio.aws.lightsail
import zio.aws.lightsail.model.DeleteAlarmResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.lightsail.model.{
  GetOperationsForResourceRequest,
  AttachStaticIpRequest,
  DeleteDiskSnapshotRequest,
  GetBucketsRequest,
  CreateContainerServiceRegistryLoginRequest,
  GetRelationalDatabaseSnapshotsRequest,
  DisableAddOnRequest,
  DetachCertificateFromDistributionRequest,
  CreateDistributionRequest,
  DeleteLoadBalancerTlsCertificateRequest,
  GetDistributionMetricDataRequest,
  GetOperationsRequest,
  GetCloudFormationStackRecordsRequest,
  GetRelationalDatabaseBlueprintsRequest,
  GetDiskSnapshotsRequest,
  DeleteDistributionRequest,
  UpdateContainerServiceRequest,
  GetDiskRequest,
  GetKeyPairRequest,
  DeleteContainerImageRequest,
  CreateRelationalDatabaseSnapshotRequest,
  GetContactMethodsRequest,
  DeleteAlarmRequest,
  CreateContainerServiceDeploymentRequest,
  IsVpcPeeredRequest,
  GetBucketBundlesRequest,
  DeleteKeyPairRequest,
  StopInstanceRequest,
  CreateRelationalDatabaseRequest,
  GetLoadBalancerRequest,
  AttachDiskRequest,
  GetInstanceAccessDetailsRequest,
  UpdateDistributionBundleRequest,
  CreateBucketAccessKeyRequest,
  CloseInstancePublicPortsRequest,
  GetAutoSnapshotsRequest,
  GetInstanceRequest,
  AllocateStaticIpRequest,
  AttachCertificateToDistributionRequest,
  UnpeerVpcRequest,
  ResetDistributionCacheRequest,
  CreateContainerServiceRequest,
  GetBundlesRequest,
  CreateCloudFormationStackRequest,
  GetContainerApiMetadataRequest,
  GetOperationRequest,
  DetachDiskRequest,
  PutAlarmRequest,
  DeleteDomainEntryRequest,
  ExportSnapshotRequest,
  CreateDiskSnapshotRequest,
  AttachLoadBalancerTlsCertificateRequest,
  GetInstanceSnapshotRequest,
  GetRelationalDatabaseEventsRequest,
  DetachStaticIpRequest,
  CopySnapshotRequest,
  SetIpAddressTypeRequest,
  RegisterContainerImageRequest,
  GetContainerImagesRequest,
  GetRelationalDatabaseRequest,
  DeleteRelationalDatabaseRequest,
  DownloadDefaultKeyPairRequest,
  CreateCertificateRequest,
  SendContactMethodVerificationRequest,
  StartRelationalDatabaseRequest,
  GetInstanceMetricDataRequest,
  UpdateLoadBalancerAttributeRequest,
  CreateRelationalDatabaseFromSnapshotRequest,
  GetInstanceSnapshotsRequest,
  GetCertificatesRequest,
  AttachInstancesToLoadBalancerRequest,
  CreateDomainEntryRequest,
  PutInstancePublicPortsRequest,
  DeleteDiskRequest,
  GetLoadBalancersRequest,
  DeleteBucketAccessKeyRequest,
  RebootRelationalDatabaseRequest,
  OpenInstancePublicPortsRequest,
  DeleteInstanceSnapshotRequest,
  CreateInstanceSnapshotRequest,
  GetDistributionBundlesRequest,
  GetInstancePortStatesRequest,
  GetLoadBalancerMetricDataRequest,
  GetRelationalDatabaseParametersRequest,
  DeleteDomainRequest,
  GetLoadBalancerTlsCertificatesRequest,
  DeleteRelationalDatabaseSnapshotRequest,
  GetAlarmsRequest,
  GetContainerLogRequest,
  GetContainerServicePowersRequest,
  DeleteBucketRequest,
  GetRelationalDatabaseSnapshotRequest,
  GetContainerServicesRequest,
  DeleteContactMethodRequest,
  CreateDiskFromSnapshotRequest,
  CreateLoadBalancerRequest,
  CreateKeyPairRequest,
  DeleteKnownHostKeysRequest,
  DeleteAutoSnapshotRequest,
  GetRelationalDatabaseMasterUserPasswordRequest,
  GetBlueprintsRequest,
  UpdateDomainEntryRequest,
  DetachInstancesFromLoadBalancerRequest,
  UpdateDistributionRequest,
  CreateContactMethodRequest,
  CreateBucketRequest,
  GetInstancesRequest,
  GetRelationalDatabaseLogEventsRequest,
  UpdateInstanceMetadataOptionsRequest,
  StopRelationalDatabaseRequest,
  DeleteLoadBalancerRequest,
  CreateDomainRequest,
  GetRelationalDatabaseMetricDataRequest,
  GetDomainsRequest,
  GetInstanceStateRequest,
  UntagResourceRequest,
  SetResourceAccessForBucketRequest,
  GetBucketAccessKeysRequest,
  DeleteInstanceRequest,
  GetRelationalDatabaseLogStreamsRequest,
  CreateLoadBalancerTlsCertificateRequest,
  UpdateRelationalDatabaseParametersRequest,
  GetStaticIpRequest,
  UpdateBucketBundleRequest,
  GetContainerServiceMetricDataRequest,
  DeleteContainerServiceRequest,
  PeerVpcRequest,
  GetDomainRequest,
  GetRelationalDatabaseBundlesRequest,
  GetKeyPairsRequest,
  GetDistributionsRequest,
  ReleaseStaticIpRequest,
  UpdateRelationalDatabaseRequest,
  RebootInstanceRequest,
  CreateInstancesRequest,
  GetDistributionLatestCacheResetRequest,
  GetStaticIpsRequest,
  CreateInstancesFromSnapshotRequest,
  UpdateBucketRequest,
  GetDisksRequest,
  GetBucketMetricDataRequest,
  EnableAddOnRequest,
  ImportKeyPairRequest,
  GetRegionsRequest,
  GetExportSnapshotRecordsRequest,
  GetDiskSnapshotRequest,
  TestAlarmRequest,
  StartInstanceRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  GetContainerServiceDeploymentsRequest,
  CreateDiskRequest,
  GetRelationalDatabasesRequest,
  GetLoadBalancerTlsPoliciesRequest,
  GetActiveNamesRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.lightsail.LightsailAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object LightsailMock extends Mock[Lightsail] {
  object PutInstancePublicPorts
      extends Effect[
        PutInstancePublicPortsRequest,
        AwsError,
        zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
      ]
  object ResetDistributionCache
      extends Effect[
        ResetDistributionCacheRequest,
        AwsError,
        zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
      ]
  object GetRelationalDatabaseSnapshot
      extends Effect[
        GetRelationalDatabaseSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
      ]
  object GetKeyPair
      extends Effect[
        GetKeyPairRequest,
        AwsError,
        zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly
      ]
  object GetInstanceAccessDetails
      extends Effect[
        GetInstanceAccessDetailsRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
      ]
  object DeleteLoadBalancerTlsCertificate
      extends Effect[
        DeleteLoadBalancerTlsCertificateRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
      ]
  object CreateDiskSnapshot
      extends Effect[
        CreateDiskSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
      ]
  object DeleteRelationalDatabase
      extends Effect[
        DeleteRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
      ]
  object ReleaseStaticIp
      extends Effect[
        ReleaseStaticIpRequest,
        AwsError,
        zio.aws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
      ]
  object UpdateLoadBalancerAttribute
      extends Effect[
        UpdateLoadBalancerAttributeRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
      ]
  object TestAlarm
      extends Effect[
        TestAlarmRequest,
        AwsError,
        zio.aws.lightsail.model.TestAlarmResponse.ReadOnly
      ]
  object CloseInstancePublicPorts
      extends Effect[
        CloseInstancePublicPortsRequest,
        AwsError,
        zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
      ]
  object DeleteContactMethod
      extends Effect[
        DeleteContactMethodRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteContactMethodResponse.ReadOnly
      ]
  object DeleteDiskSnapshot
      extends Effect[
        DeleteDiskSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
      ]
  object PutAlarm
      extends Effect[
        PutAlarmRequest,
        AwsError,
        zio.aws.lightsail.model.PutAlarmResponse.ReadOnly
      ]
  object GetInstances
      extends Effect[
        GetInstancesRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstancesResponse.ReadOnly
      ]
  object CreateCertificate
      extends Effect[
        CreateCertificateRequest,
        AwsError,
        zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly
      ]
  object GetRelationalDatabaseLogEvents
      extends Effect[
        GetRelationalDatabaseLogEventsRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
      ]
  object DeleteKnownHostKeys
      extends Effect[
        DeleteKnownHostKeysRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
      ]
  object RebootRelationalDatabase
      extends Effect[
        RebootRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
      ]
  object CreateCloudFormationStack
      extends Effect[
        CreateCloudFormationStackRequest,
        AwsError,
        zio.aws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
      ]
  object GetBucketMetricData
      extends Effect[
        GetBucketMetricDataRequest,
        AwsError,
        zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
      ]
  object DetachDisk
      extends Effect[
        DetachDiskRequest,
        AwsError,
        zio.aws.lightsail.model.DetachDiskResponse.ReadOnly
      ]
  object AllocateStaticIp
      extends Effect[
        AllocateStaticIpRequest,
        AwsError,
        zio.aws.lightsail.model.AllocateStaticIpResponse.ReadOnly
      ]
  object GetRelationalDatabaseEvents
      extends Effect[
        GetRelationalDatabaseEventsRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
      ]
  object GetOperations
      extends Effect[
        GetOperationsRequest,
        AwsError,
        zio.aws.lightsail.model.GetOperationsResponse.ReadOnly
      ]
  object GetInstanceState
      extends Effect[
        GetInstanceStateRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly
      ]
  object GetDomains
      extends Effect[
        GetDomainsRequest,
        AwsError,
        zio.aws.lightsail.model.GetDomainsResponse.ReadOnly
      ]
  object GetLoadBalancers
      extends Effect[
        GetLoadBalancersRequest,
        AwsError,
        zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly
      ]
  object GetContainerServices
      extends Effect[
        GetContainerServicesRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly
      ]
  object GetLoadBalancerTlsCertificates
      extends Effect[
        GetLoadBalancerTlsCertificatesRequest,
        AwsError,
        zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
      ]
  object CreateRelationalDatabaseFromSnapshot
      extends Effect[
        CreateRelationalDatabaseFromSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
      ]
  object GetInstanceSnapshot
      extends Effect[
        GetInstanceSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
      ]
  object DeleteContainerService
      extends Effect[
        DeleteContainerServiceRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
      ]
  object GetContainerAPIMetadata
      extends Effect[
        GetContainerApiMetadataRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
      ]
  object GetDiskSnapshot
      extends Effect[
        GetDiskSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
      ]
  object DetachStaticIp
      extends Effect[
        DetachStaticIpRequest,
        AwsError,
        zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly
      ]
  object CreateDisk
      extends Effect[
        CreateDiskRequest,
        AwsError,
        zio.aws.lightsail.model.CreateDiskResponse.ReadOnly
      ]
  object GetContainerImages
      extends Effect[
        GetContainerImagesRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly
      ]
  object DeleteBucketAccessKey
      extends Effect[
        DeleteBucketAccessKeyRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
      ]
  object CreateDomainEntry
      extends Effect[
        CreateDomainEntryRequest,
        AwsError,
        zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly
      ]
  object SendContactMethodVerification
      extends Effect[
        SendContactMethodVerificationRequest,
        AwsError,
        zio.aws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
      ]
  object GetDomain
      extends Effect[
        GetDomainRequest,
        AwsError,
        zio.aws.lightsail.model.GetDomainResponse.ReadOnly
      ]
  object DeleteInstance
      extends Effect[
        DeleteInstanceRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteInstanceResponse.ReadOnly
      ]
  object CopySnapshot
      extends Effect[
        CopySnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CopySnapshotResponse.ReadOnly
      ]
  object GetContactMethods
      extends Effect[
        GetContactMethodsRequest,
        AwsError,
        zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly
      ]
  object GetRelationalDatabaseBundles
      extends Effect[
        GetRelationalDatabaseBundlesRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
      ]
  object DetachInstancesFromLoadBalancer
      extends Effect[
        DetachInstancesFromLoadBalancerRequest,
        AwsError,
        zio.aws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
      ]
  object OpenInstancePublicPorts
      extends Effect[
        OpenInstancePublicPortsRequest,
        AwsError,
        zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
      ]
  object GetInstanceMetricData
      extends Effect[
        GetInstanceMetricDataRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
      ]
  object DeleteRelationalDatabaseSnapshot
      extends Effect[
        DeleteRelationalDatabaseSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
      ]
  object AttachInstancesToLoadBalancer
      extends Effect[
        AttachInstancesToLoadBalancerRequest,
        AwsError,
        zio.aws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
      ]
  object GetDistributionBundles
      extends Effect[
        GetDistributionBundlesRequest,
        AwsError,
        zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
      ]
  object GetRelationalDatabaseParameters
      extends Effect[
        GetRelationalDatabaseParametersRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
      ]
  object GetAlarms
      extends Effect[
        GetAlarmsRequest,
        AwsError,
        zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly
      ]
  object DeleteLoadBalancer
      extends Effect[
        DeleteLoadBalancerRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
      ]
  object GetInstanceSnapshots
      extends Effect[
        GetInstanceSnapshotsRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
      ]
  object StopRelationalDatabase
      extends Effect[
        StopRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
      ]
  object GetLoadBalancerMetricData
      extends Effect[
        GetLoadBalancerMetricDataRequest,
        AwsError,
        zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
      ]
  object AttachCertificateToDistribution
      extends Effect[
        AttachCertificateToDistributionRequest,
        AwsError,
        zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
      ]
  object DeleteCertificate
      extends Effect[
        DeleteCertificateRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteCertificateResponse.ReadOnly
      ]
  object GetInstance
      extends Effect[
        GetInstanceRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstanceResponse.ReadOnly
      ]
  object GetDistributions
      extends Effect[
        GetDistributionsRequest,
        AwsError,
        zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly
      ]
  object GetRelationalDatabases
      extends Effect[
        GetRelationalDatabasesRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
      ]
  object AttachLoadBalancerTlsCertificate
      extends Effect[
        AttachLoadBalancerTlsCertificateRequest,
        AwsError,
        zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
      ]
  object GetOperationsForResource
      extends Effect[
        GetOperationsForResourceRequest,
        AwsError,
        zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
      ]
  object CreateDiskFromSnapshot
      extends Effect[
        CreateDiskFromSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
      ]
  object GetLoadBalancer
      extends Effect[
        GetLoadBalancerRequest,
        AwsError,
        zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly
      ]
  object GetBucketBundles
      extends Effect[
        GetBucketBundlesRequest,
        AwsError,
        zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly
      ]
  object DeleteInstanceSnapshot
      extends Effect[
        DeleteInstanceSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
      ]
  object DeleteDomainEntry
      extends Effect[
        DeleteDomainEntryRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
      ]
  object UpdateRelationalDatabase
      extends Effect[
        UpdateRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
      ]
  object PeerVpc
      extends Effect[
        PeerVpcRequest,
        AwsError,
        zio.aws.lightsail.model.PeerVpcResponse.ReadOnly
      ]
  object UnpeerVpc
      extends Effect[
        UnpeerVpcRequest,
        AwsError,
        zio.aws.lightsail.model.UnpeerVpcResponse.ReadOnly
      ]
  object GetActiveNames
      extends Effect[
        GetActiveNamesRequest,
        AwsError,
        zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly
      ]
  object DeleteBucket
      extends Effect[
        DeleteBucketRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteBucketResponse.ReadOnly
      ]
  object GetAutoSnapshots
      extends Effect[
        GetAutoSnapshotsRequest,
        AwsError,
        zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
      ]
  object StartRelationalDatabase
      extends Effect[
        StartRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
      ]
  object CreateInstanceSnapshot
      extends Effect[
        CreateInstanceSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
      ]
  object UpdateDomainEntry
      extends Effect[
        UpdateDomainEntryRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
      ]
  object UpdateBucket
      extends Effect[
        UpdateBucketRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly
      ]
  object RebootInstance
      extends Effect[
        RebootInstanceRequest,
        AwsError,
        zio.aws.lightsail.model.RebootInstanceResponse.ReadOnly
      ]
  object CreateContactMethod
      extends Effect[
        CreateContactMethodRequest,
        AwsError,
        zio.aws.lightsail.model.CreateContactMethodResponse.ReadOnly
      ]
  object GetDiskSnapshots
      extends Effect[
        GetDiskSnapshotsRequest,
        AwsError,
        zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
      ]
  object CreateBucket
      extends Effect[
        CreateBucketRequest,
        AwsError,
        zio.aws.lightsail.model.CreateBucketResponse.ReadOnly
      ]
  object GetContainerLog
      extends Effect[
        GetContainerLogRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly
      ]
  object GetContainerServiceDeployments
      extends Effect[
        GetContainerServiceDeploymentsRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
      ]
  object CreateDomain
      extends Effect[
        CreateDomainRequest,
        AwsError,
        zio.aws.lightsail.model.CreateDomainResponse.ReadOnly
      ]
  object SetResourceAccessForBucket
      extends Effect[
        SetResourceAccessForBucketRequest,
        AwsError,
        zio.aws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
      ]
  object GetBucketAccessKeys
      extends Effect[
        GetBucketAccessKeysRequest,
        AwsError,
        zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
      ]
  object CreateContainerService
      extends Effect[
        CreateContainerServiceRequest,
        AwsError,
        zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly
      ]
  object IsVpcPeered
      extends Effect[
        IsVpcPeeredRequest,
        AwsError,
        zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly
      ]
  object DeleteAutoSnapshot
      extends Effect[
        DeleteAutoSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
      ]
  object CreateContainerServiceRegistryLogin
      extends Effect[
        CreateContainerServiceRegistryLoginRequest,
        AwsError,
        zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
      ]
  object GetDisk
      extends Effect[
        GetDiskRequest,
        AwsError,
        zio.aws.lightsail.model.GetDiskResponse.ReadOnly
      ]
  object EnableAddOn
      extends Effect[
        EnableAddOnRequest,
        AwsError,
        zio.aws.lightsail.model.EnableAddOnResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.lightsail.model.UntagResourceResponse.ReadOnly
      ]
  object CreateLoadBalancerTlsCertificate
      extends Effect[
        CreateLoadBalancerTlsCertificateRequest,
        AwsError,
        zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
      ]
  object GetStaticIp
      extends Effect[
        GetStaticIpRequest,
        AwsError,
        zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly
      ]
  object AttachStaticIp
      extends Effect[
        AttachStaticIpRequest,
        AwsError,
        zio.aws.lightsail.model.AttachStaticIpResponse.ReadOnly
      ]
  object ImportKeyPair
      extends Effect[
        ImportKeyPairRequest,
        AwsError,
        zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly
      ]
  object GetDisks
      extends Effect[
        GetDisksRequest,
        AwsError,
        zio.aws.lightsail.model.GetDisksResponse.ReadOnly
      ]
  object DownloadDefaultKeyPair
      extends Effect[
        DownloadDefaultKeyPairRequest,
        AwsError,
        zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
      ]
  object GetExportSnapshotRecords
      extends Effect[
        GetExportSnapshotRecordsRequest,
        AwsError,
        zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
      ]
  object CreateKeyPair
      extends Effect[
        CreateKeyPairRequest,
        AwsError,
        zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly
      ]
  object GetLoadBalancerTlsPolicies
      extends Effect[
        GetLoadBalancerTlsPoliciesRequest,
        AwsError,
        zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly
      ]
  object GetBundles
      extends Effect[
        GetBundlesRequest,
        AwsError,
        zio.aws.lightsail.model.GetBundlesResponse.ReadOnly
      ]
  object RegisterContainerImage
      extends Effect[
        RegisterContainerImageRequest,
        AwsError,
        zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly
      ]
  object StartInstance
      extends Effect[
        StartInstanceRequest,
        AwsError,
        zio.aws.lightsail.model.StartInstanceResponse.ReadOnly
      ]
  object GetInstancePortStates
      extends Effect[
        GetInstancePortStatesRequest,
        AwsError,
        zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
      ]
  object DeleteDisk
      extends Effect[
        DeleteDiskRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteDiskResponse.ReadOnly
      ]
  object UpdateInstanceMetadataOptions
      extends Effect[
        UpdateInstanceMetadataOptionsRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly
      ]
  object GetBlueprints
      extends Effect[
        GetBlueprintsRequest,
        AwsError,
        zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly
      ]
  object DeleteAlarm extends Effect[DeleteAlarmRequest, AwsError, ReadOnly]
  object CreateRelationalDatabaseSnapshot
      extends Effect[
        CreateRelationalDatabaseSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
      ]
  object GetContainerServiceMetricData
      extends Effect[
        GetContainerServiceMetricDataRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
      ]
  object GetRelationalDatabaseLogStreams
      extends Effect[
        GetRelationalDatabaseLogStreamsRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
      ]
  object UpdateRelationalDatabaseParameters
      extends Effect[
        UpdateRelationalDatabaseParametersRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
      ]
  object CreateContainerServiceDeployment
      extends Effect[
        CreateContainerServiceDeploymentRequest,
        AwsError,
        zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
      ]
  object GetDistributionLatestCacheReset
      extends Effect[
        GetDistributionLatestCacheResetRequest,
        AwsError,
        zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
      ]
  object UpdateDistributionBundle
      extends Effect[
        UpdateDistributionBundleRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
      ]
  object DeleteKeyPair
      extends Effect[
        DeleteKeyPairRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteKeyPairResponse.ReadOnly
      ]
  object UpdateBucketBundle
      extends Effect[
        UpdateBucketBundleRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
      ]
  object GetStaticIps
      extends Effect[
        GetStaticIpsRequest,
        AwsError,
        zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly
      ]
  object CreateRelationalDatabase
      extends Effect[
        CreateRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
      ]
  object GetCertificates
      extends Effect[
        GetCertificatesRequest,
        AwsError,
        zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.lightsail.model.TagResourceResponse.ReadOnly
      ]
  object DeleteDomain
      extends Effect[
        DeleteDomainRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteDomainResponse.ReadOnly
      ]
  object CreateBucketAccessKey
      extends Effect[
        CreateBucketAccessKeyRequest,
        AwsError,
        zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
      ]
  object GetRelationalDatabaseSnapshots
      extends Effect[
        GetRelationalDatabaseSnapshotsRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
      ]
  object CreateInstancesFromSnapshot
      extends Effect[
        CreateInstancesFromSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
      ]
  object ExportSnapshot
      extends Effect[
        ExportSnapshotRequest,
        AwsError,
        zio.aws.lightsail.model.ExportSnapshotResponse.ReadOnly
      ]
  object AttachDisk
      extends Effect[
        AttachDiskRequest,
        AwsError,
        zio.aws.lightsail.model.AttachDiskResponse.ReadOnly
      ]
  object SetIpAddressType
      extends Effect[
        SetIpAddressTypeRequest,
        AwsError,
        zio.aws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
      ]
  object GetRegions
      extends Effect[
        GetRegionsRequest,
        AwsError,
        zio.aws.lightsail.model.GetRegionsResponse.ReadOnly
      ]
  object GetRelationalDatabaseMetricData
      extends Effect[
        GetRelationalDatabaseMetricDataRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
      ]
  object GetOperation
      extends Effect[
        GetOperationRequest,
        AwsError,
        zio.aws.lightsail.model.GetOperationResponse.ReadOnly
      ]
  object StopInstance
      extends Effect[
        StopInstanceRequest,
        AwsError,
        zio.aws.lightsail.model.StopInstanceResponse.ReadOnly
      ]
  object GetDistributionMetricData
      extends Effect[
        GetDistributionMetricDataRequest,
        AwsError,
        zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
      ]
  object GetKeyPairs
      extends Effect[
        GetKeyPairsRequest,
        AwsError,
        zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly
      ]
  object DisableAddOn
      extends Effect[
        DisableAddOnRequest,
        AwsError,
        zio.aws.lightsail.model.DisableAddOnResponse.ReadOnly
      ]
  object CreateInstances
      extends Effect[
        CreateInstancesRequest,
        AwsError,
        zio.aws.lightsail.model.CreateInstancesResponse.ReadOnly
      ]
  object CreateLoadBalancer
      extends Effect[
        CreateLoadBalancerRequest,
        AwsError,
        zio.aws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
      ]
  object GetRelationalDatabaseBlueprints
      extends Effect[
        GetRelationalDatabaseBlueprintsRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
      ]
  object DetachCertificateFromDistribution
      extends Effect[
        DetachCertificateFromDistributionRequest,
        AwsError,
        zio.aws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
      ]
  object GetRelationalDatabaseMasterUserPassword
      extends Effect[
        GetRelationalDatabaseMasterUserPasswordRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
      ]
  object UpdateContainerService
      extends Effect[
        UpdateContainerServiceRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
      ]
  object GetContainerServicePowers
      extends Effect[
        GetContainerServicePowersRequest,
        AwsError,
        zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
      ]
  object GetRelationalDatabase
      extends Effect[
        GetRelationalDatabaseRequest,
        AwsError,
        zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
      ]
  object GetBuckets
      extends Effect[
        GetBucketsRequest,
        AwsError,
        zio.aws.lightsail.model.GetBucketsResponse.ReadOnly
      ]
  object GetCloudFormationStackRecords
      extends Effect[
        GetCloudFormationStackRecordsRequest,
        AwsError,
        zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
      ]
  object UpdateDistribution
      extends Effect[
        UpdateDistributionRequest,
        AwsError,
        zio.aws.lightsail.model.UpdateDistributionResponse.ReadOnly
      ]
  object DeleteDistribution
      extends Effect[
        DeleteDistributionRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly
      ]
  object DeleteContainerImage
      extends Effect[
        DeleteContainerImageRequest,
        AwsError,
        zio.aws.lightsail.model.DeleteContainerImageResponse.ReadOnly
      ]
  object CreateDistribution
      extends Effect[
        CreateDistributionRequest,
        AwsError,
        zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Lightsail] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Lightsail] { rts =>
        zio.ZIO.succeed {
          new Lightsail {
            val api: LightsailAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Lightsail = this
            def putInstancePublicPorts(
                request: PutInstancePublicPortsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
            ] = proxy(PutInstancePublicPorts, request)
            def resetDistributionCache(
                request: ResetDistributionCacheRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
            ] = proxy(ResetDistributionCache, request)
            def getRelationalDatabaseSnapshot(
                request: GetRelationalDatabaseSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseSnapshot, request)
            def getKeyPair(request: GetKeyPairRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly
            ] = proxy(GetKeyPair, request)
            def getInstanceAccessDetails(
                request: GetInstanceAccessDetailsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
            ] = proxy(GetInstanceAccessDetails, request)
            def deleteLoadBalancerTlsCertificate(
                request: DeleteLoadBalancerTlsCertificateRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
            ] = proxy(DeleteLoadBalancerTlsCertificate, request)
            def createDiskSnapshot(request: CreateDiskSnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
            ] = proxy(CreateDiskSnapshot, request)
            def deleteRelationalDatabase(
                request: DeleteRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
            ] = proxy(DeleteRelationalDatabase, request)
            def releaseStaticIp(request: ReleaseStaticIpRequest): IO[
              AwsError,
              zio.aws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
            ] = proxy(ReleaseStaticIp, request)
            def updateLoadBalancerAttribute(
                request: UpdateLoadBalancerAttributeRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
            ] = proxy(UpdateLoadBalancerAttribute, request)
            def testAlarm(request: TestAlarmRequest): IO[
              AwsError,
              zio.aws.lightsail.model.TestAlarmResponse.ReadOnly
            ] = proxy(TestAlarm, request)
            def closeInstancePublicPorts(
                request: CloseInstancePublicPortsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
            ] = proxy(CloseInstancePublicPorts, request)
            def deleteContactMethod(request: DeleteContactMethodRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteContactMethodResponse.ReadOnly
            ] = proxy(DeleteContactMethod, request)
            def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
            ] = proxy(DeleteDiskSnapshot, request)
            def putAlarm(
                request: PutAlarmRequest
            ): IO[AwsError, zio.aws.lightsail.model.PutAlarmResponse.ReadOnly] =
              proxy(PutAlarm, request)
            def getInstances(request: GetInstancesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstancesResponse.ReadOnly
            ] = proxy(GetInstances, request)
            def createCertificate(request: CreateCertificateRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly
            ] = proxy(CreateCertificate, request)
            def getRelationalDatabaseLogEvents(
                request: GetRelationalDatabaseLogEventsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseLogEvents, request)
            def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
            ] = proxy(DeleteKnownHostKeys, request)
            def rebootRelationalDatabase(
                request: RebootRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
            ] = proxy(RebootRelationalDatabase, request)
            def createCloudFormationStack(
                request: CreateCloudFormationStackRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
            ] = proxy(CreateCloudFormationStack, request)
            def getBucketMetricData(request: GetBucketMetricDataRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
            ] = proxy(GetBucketMetricData, request)
            def detachDisk(request: DetachDiskRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DetachDiskResponse.ReadOnly
            ] = proxy(DetachDisk, request)
            def allocateStaticIp(request: AllocateStaticIpRequest): IO[
              AwsError,
              zio.aws.lightsail.model.AllocateStaticIpResponse.ReadOnly
            ] = proxy(AllocateStaticIp, request)
            def getRelationalDatabaseEvents(
                request: GetRelationalDatabaseEventsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseEvents, request)
            def getOperations(request: GetOperationsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetOperationsResponse.ReadOnly
            ] = proxy(GetOperations, request)
            def getInstanceState(request: GetInstanceStateRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly
            ] = proxy(GetInstanceState, request)
            def getDomains(request: GetDomainsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetDomainsResponse.ReadOnly
            ] = proxy(GetDomains, request)
            def getLoadBalancers(request: GetLoadBalancersRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly
            ] = proxy(GetLoadBalancers, request)
            def getContainerServices(request: GetContainerServicesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly
            ] = proxy(GetContainerServices, request)
            def getLoadBalancerTlsCertificates(
                request: GetLoadBalancerTlsCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
            ] = proxy(GetLoadBalancerTlsCertificates, request)
            def createRelationalDatabaseFromSnapshot(
                request: CreateRelationalDatabaseFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
            ] = proxy(CreateRelationalDatabaseFromSnapshot, request)
            def getInstanceSnapshot(request: GetInstanceSnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
            ] = proxy(GetInstanceSnapshot, request)
            def deleteContainerService(
                request: DeleteContainerServiceRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
            ] = proxy(DeleteContainerService, request)
            def getContainerAPIMetadata(
                request: GetContainerApiMetadataRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
            ] = proxy(GetContainerAPIMetadata, request)
            def getDiskSnapshot(request: GetDiskSnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
            ] = proxy(GetDiskSnapshot, request)
            def detachStaticIp(request: DetachStaticIpRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly
            ] = proxy(DetachStaticIp, request)
            def createDisk(request: CreateDiskRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateDiskResponse.ReadOnly
            ] = proxy(CreateDisk, request)
            def getContainerImages(request: GetContainerImagesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly
            ] = proxy(GetContainerImages, request)
            def deleteBucketAccessKey(
                request: DeleteBucketAccessKeyRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
            ] = proxy(DeleteBucketAccessKey, request)
            def createDomainEntry(request: CreateDomainEntryRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly
            ] = proxy(CreateDomainEntry, request)
            def sendContactMethodVerification(
                request: SendContactMethodVerificationRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
            ] = proxy(SendContactMethodVerification, request)
            def getDomain(request: GetDomainRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetDomainResponse.ReadOnly
            ] = proxy(GetDomain, request)
            def deleteInstance(request: DeleteInstanceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteInstanceResponse.ReadOnly
            ] = proxy(DeleteInstance, request)
            def copySnapshot(request: CopySnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CopySnapshotResponse.ReadOnly
            ] = proxy(CopySnapshot, request)
            def getContactMethods(request: GetContactMethodsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly
            ] = proxy(GetContactMethods, request)
            def getRelationalDatabaseBundles(
                request: GetRelationalDatabaseBundlesRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseBundles, request)
            def detachInstancesFromLoadBalancer(
                request: DetachInstancesFromLoadBalancerRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
            ] = proxy(DetachInstancesFromLoadBalancer, request)
            def openInstancePublicPorts(
                request: OpenInstancePublicPortsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
            ] = proxy(OpenInstancePublicPorts, request)
            def getInstanceMetricData(
                request: GetInstanceMetricDataRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
            ] = proxy(GetInstanceMetricData, request)
            def deleteRelationalDatabaseSnapshot(
                request: DeleteRelationalDatabaseSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
            ] = proxy(DeleteRelationalDatabaseSnapshot, request)
            def attachInstancesToLoadBalancer(
                request: AttachInstancesToLoadBalancerRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
            ] = proxy(AttachInstancesToLoadBalancer, request)
            def getDistributionBundles(
                request: GetDistributionBundlesRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
            ] = proxy(GetDistributionBundles, request)
            def getRelationalDatabaseParameters(
                request: GetRelationalDatabaseParametersRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseParameters, request)
            def getAlarms(request: GetAlarmsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly
            ] = proxy(GetAlarms, request)
            def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
            ] = proxy(DeleteLoadBalancer, request)
            def getInstanceSnapshots(request: GetInstanceSnapshotsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
            ] = proxy(GetInstanceSnapshots, request)
            def stopRelationalDatabase(
                request: StopRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
            ] = proxy(StopRelationalDatabase, request)
            def getLoadBalancerMetricData(
                request: GetLoadBalancerMetricDataRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
            ] = proxy(GetLoadBalancerMetricData, request)
            def attachCertificateToDistribution(
                request: AttachCertificateToDistributionRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
            ] = proxy(AttachCertificateToDistribution, request)
            def deleteCertificate(request: DeleteCertificateRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteCertificateResponse.ReadOnly
            ] = proxy(DeleteCertificate, request)
            def getInstance(request: GetInstanceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstanceResponse.ReadOnly
            ] = proxy(GetInstance, request)
            def getDistributions(request: GetDistributionsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly
            ] = proxy(GetDistributions, request)
            def getRelationalDatabases(
                request: GetRelationalDatabasesRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
            ] = proxy(GetRelationalDatabases, request)
            def attachLoadBalancerTlsCertificate(
                request: AttachLoadBalancerTlsCertificateRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
            ] = proxy(AttachLoadBalancerTlsCertificate, request)
            def getOperationsForResource(
                request: GetOperationsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
            ] = proxy(GetOperationsForResource, request)
            def createDiskFromSnapshot(
                request: CreateDiskFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
            ] = proxy(CreateDiskFromSnapshot, request)
            def getLoadBalancer(request: GetLoadBalancerRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly
            ] = proxy(GetLoadBalancer, request)
            def getBucketBundles(request: GetBucketBundlesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly
            ] = proxy(GetBucketBundles, request)
            def deleteInstanceSnapshot(
                request: DeleteInstanceSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
            ] = proxy(DeleteInstanceSnapshot, request)
            def deleteDomainEntry(request: DeleteDomainEntryRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
            ] = proxy(DeleteDomainEntry, request)
            def updateRelationalDatabase(
                request: UpdateRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
            ] = proxy(UpdateRelationalDatabase, request)
            def peerVpc(
                request: PeerVpcRequest
            ): IO[AwsError, zio.aws.lightsail.model.PeerVpcResponse.ReadOnly] =
              proxy(PeerVpc, request)
            def unpeerVpc(request: UnpeerVpcRequest): IO[
              AwsError,
              zio.aws.lightsail.model.UnpeerVpcResponse.ReadOnly
            ] = proxy(UnpeerVpc, request)
            def getActiveNames(request: GetActiveNamesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly
            ] = proxy(GetActiveNames, request)
            def deleteBucket(request: DeleteBucketRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteBucketResponse.ReadOnly
            ] = proxy(DeleteBucket, request)
            def getAutoSnapshots(request: GetAutoSnapshotsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
            ] = proxy(GetAutoSnapshots, request)
            def startRelationalDatabase(
                request: StartRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
            ] = proxy(StartRelationalDatabase, request)
            def createInstanceSnapshot(
                request: CreateInstanceSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
            ] = proxy(CreateInstanceSnapshot, request)
            def updateDomainEntry(request: UpdateDomainEntryRequest): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
            ] = proxy(UpdateDomainEntry, request)
            def updateBucket(request: UpdateBucketRequest): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly
            ] = proxy(UpdateBucket, request)
            def rebootInstance(request: RebootInstanceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.RebootInstanceResponse.ReadOnly
            ] = proxy(RebootInstance, request)
            def createContactMethod(request: CreateContactMethodRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateContactMethodResponse.ReadOnly
            ] = proxy(CreateContactMethod, request)
            def getDiskSnapshots(request: GetDiskSnapshotsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
            ] = proxy(GetDiskSnapshots, request)
            def createBucket(request: CreateBucketRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateBucketResponse.ReadOnly
            ] = proxy(CreateBucket, request)
            def getContainerLog(request: GetContainerLogRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly
            ] = proxy(GetContainerLog, request)
            def getContainerServiceDeployments(
                request: GetContainerServiceDeploymentsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
            ] = proxy(GetContainerServiceDeployments, request)
            def createDomain(request: CreateDomainRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateDomainResponse.ReadOnly
            ] = proxy(CreateDomain, request)
            def setResourceAccessForBucket(
                request: SetResourceAccessForBucketRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
            ] = proxy(SetResourceAccessForBucket, request)
            def getBucketAccessKeys(request: GetBucketAccessKeysRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
            ] = proxy(GetBucketAccessKeys, request)
            def createContainerService(
                request: CreateContainerServiceRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly
            ] = proxy(CreateContainerService, request)
            def isVpcPeered(request: IsVpcPeeredRequest): IO[
              AwsError,
              zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly
            ] = proxy(IsVpcPeered, request)
            def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
            ] = proxy(DeleteAutoSnapshot, request)
            def createContainerServiceRegistryLogin(
                request: CreateContainerServiceRegistryLoginRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
            ] = proxy(CreateContainerServiceRegistryLogin, request)
            def getDisk(
                request: GetDiskRequest
            ): IO[AwsError, zio.aws.lightsail.model.GetDiskResponse.ReadOnly] =
              proxy(GetDisk, request)
            def enableAddOn(request: EnableAddOnRequest): IO[
              AwsError,
              zio.aws.lightsail.model.EnableAddOnResponse.ReadOnly
            ] = proxy(EnableAddOn, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createLoadBalancerTlsCertificate(
                request: CreateLoadBalancerTlsCertificateRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
            ] = proxy(CreateLoadBalancerTlsCertificate, request)
            def getStaticIp(request: GetStaticIpRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly
            ] = proxy(GetStaticIp, request)
            def attachStaticIp(request: AttachStaticIpRequest): IO[
              AwsError,
              zio.aws.lightsail.model.AttachStaticIpResponse.ReadOnly
            ] = proxy(AttachStaticIp, request)
            def importKeyPair(request: ImportKeyPairRequest): IO[
              AwsError,
              zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly
            ] = proxy(ImportKeyPair, request)
            def getDisks(
                request: GetDisksRequest
            ): IO[AwsError, zio.aws.lightsail.model.GetDisksResponse.ReadOnly] =
              proxy(GetDisks, request)
            def downloadDefaultKeyPair(
                request: DownloadDefaultKeyPairRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
            ] = proxy(DownloadDefaultKeyPair, request)
            def getExportSnapshotRecords(
                request: GetExportSnapshotRecordsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
            ] = proxy(GetExportSnapshotRecords, request)
            def createKeyPair(request: CreateKeyPairRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly
            ] = proxy(CreateKeyPair, request)
            def getLoadBalancerTlsPolicies(
                request: GetLoadBalancerTlsPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly
            ] = proxy(GetLoadBalancerTlsPolicies, request)
            def getBundles(request: GetBundlesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetBundlesResponse.ReadOnly
            ] = proxy(GetBundles, request)
            def registerContainerImage(
                request: RegisterContainerImageRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly
            ] = proxy(RegisterContainerImage, request)
            def startInstance(request: StartInstanceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.StartInstanceResponse.ReadOnly
            ] = proxy(StartInstance, request)
            def getInstancePortStates(
                request: GetInstancePortStatesRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
            ] = proxy(GetInstancePortStates, request)
            def deleteDisk(request: DeleteDiskRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteDiskResponse.ReadOnly
            ] = proxy(DeleteDisk, request)
            def updateInstanceMetadataOptions(
                request: UpdateInstanceMetadataOptionsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly
            ] = proxy(UpdateInstanceMetadataOptions, request)
            def getBlueprints(request: GetBlueprintsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly
            ] = proxy(GetBlueprints, request)
            def deleteAlarm(
                request: DeleteAlarmRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteAlarm, request)
            def createRelationalDatabaseSnapshot(
                request: CreateRelationalDatabaseSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
            ] = proxy(CreateRelationalDatabaseSnapshot, request)
            def getContainerServiceMetricData(
                request: GetContainerServiceMetricDataRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
            ] = proxy(GetContainerServiceMetricData, request)
            def getRelationalDatabaseLogStreams(
                request: GetRelationalDatabaseLogStreamsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseLogStreams, request)
            def updateRelationalDatabaseParameters(
                request: UpdateRelationalDatabaseParametersRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
            ] = proxy(UpdateRelationalDatabaseParameters, request)
            def createContainerServiceDeployment(
                request: CreateContainerServiceDeploymentRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
            ] = proxy(CreateContainerServiceDeployment, request)
            def getDistributionLatestCacheReset(
                request: GetDistributionLatestCacheResetRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
            ] = proxy(GetDistributionLatestCacheReset, request)
            def updateDistributionBundle(
                request: UpdateDistributionBundleRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
            ] = proxy(UpdateDistributionBundle, request)
            def deleteKeyPair(request: DeleteKeyPairRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteKeyPairResponse.ReadOnly
            ] = proxy(DeleteKeyPair, request)
            def updateBucketBundle(request: UpdateBucketBundleRequest): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
            ] = proxy(UpdateBucketBundle, request)
            def getStaticIps(request: GetStaticIpsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly
            ] = proxy(GetStaticIps, request)
            def createRelationalDatabase(
                request: CreateRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
            ] = proxy(CreateRelationalDatabase, request)
            def getCertificates(request: GetCertificatesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly
            ] = proxy(GetCertificates, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteDomain(request: DeleteDomainRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteDomainResponse.ReadOnly
            ] = proxy(DeleteDomain, request)
            def createBucketAccessKey(
                request: CreateBucketAccessKeyRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
            ] = proxy(CreateBucketAccessKey, request)
            def getRelationalDatabaseSnapshots(
                request: GetRelationalDatabaseSnapshotsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseSnapshots, request)
            def createInstancesFromSnapshot(
                request: CreateInstancesFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
            ] = proxy(CreateInstancesFromSnapshot, request)
            def exportSnapshot(request: ExportSnapshotRequest): IO[
              AwsError,
              zio.aws.lightsail.model.ExportSnapshotResponse.ReadOnly
            ] = proxy(ExportSnapshot, request)
            def attachDisk(request: AttachDiskRequest): IO[
              AwsError,
              zio.aws.lightsail.model.AttachDiskResponse.ReadOnly
            ] = proxy(AttachDisk, request)
            def setIpAddressType(request: SetIpAddressTypeRequest): IO[
              AwsError,
              zio.aws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
            ] = proxy(SetIpAddressType, request)
            def getRegions(request: GetRegionsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetRegionsResponse.ReadOnly
            ] = proxy(GetRegions, request)
            def getRelationalDatabaseMetricData(
                request: GetRelationalDatabaseMetricDataRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseMetricData, request)
            def getOperation(request: GetOperationRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetOperationResponse.ReadOnly
            ] = proxy(GetOperation, request)
            def stopInstance(request: StopInstanceRequest): IO[
              AwsError,
              zio.aws.lightsail.model.StopInstanceResponse.ReadOnly
            ] = proxy(StopInstance, request)
            def getDistributionMetricData(
                request: GetDistributionMetricDataRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
            ] = proxy(GetDistributionMetricData, request)
            def getKeyPairs(request: GetKeyPairsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly
            ] = proxy(GetKeyPairs, request)
            def disableAddOn(request: DisableAddOnRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DisableAddOnResponse.ReadOnly
            ] = proxy(DisableAddOn, request)
            def createInstances(request: CreateInstancesRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateInstancesResponse.ReadOnly
            ] = proxy(CreateInstances, request)
            def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
            ] = proxy(CreateLoadBalancer, request)
            def getRelationalDatabaseBlueprints(
                request: GetRelationalDatabaseBlueprintsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseBlueprints, request)
            def detachCertificateFromDistribution(
                request: DetachCertificateFromDistributionRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
            ] = proxy(DetachCertificateFromDistribution, request)
            def getRelationalDatabaseMasterUserPassword(
                request: GetRelationalDatabaseMasterUserPasswordRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
            ] = proxy(GetRelationalDatabaseMasterUserPassword, request)
            def updateContainerService(
                request: UpdateContainerServiceRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
            ] = proxy(UpdateContainerService, request)
            def getContainerServicePowers(
                request: GetContainerServicePowersRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
            ] = proxy(GetContainerServicePowers, request)
            def getRelationalDatabase(
                request: GetRelationalDatabaseRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
            ] = proxy(GetRelationalDatabase, request)
            def getBuckets(request: GetBucketsRequest): IO[
              AwsError,
              zio.aws.lightsail.model.GetBucketsResponse.ReadOnly
            ] = proxy(GetBuckets, request)
            def getCloudFormationStackRecords(
                request: GetCloudFormationStackRecordsRequest
            ): IO[
              AwsError,
              zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
            ] = proxy(GetCloudFormationStackRecords, request)
            def updateDistribution(request: UpdateDistributionRequest): IO[
              AwsError,
              zio.aws.lightsail.model.UpdateDistributionResponse.ReadOnly
            ] = proxy(UpdateDistribution, request)
            def deleteDistribution(request: DeleteDistributionRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly
            ] = proxy(DeleteDistribution, request)
            def deleteContainerImage(request: DeleteContainerImageRequest): IO[
              AwsError,
              zio.aws.lightsail.model.DeleteContainerImageResponse.ReadOnly
            ] = proxy(DeleteContainerImage, request)
            def createDistribution(request: CreateDistributionRequest): IO[
              AwsError,
              zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly
            ] = proxy(CreateDistribution, request)
          }
        }
      }
    }
  }
}
