package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait AccessType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AccessType
}
object AccessType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AccessType
  ): zio.aws.lightsail.model.AccessType = value match {
    case software.amazon.awssdk.services.lightsail.model.AccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AccessType.PUBLIC =>
      val r = public
      r
    case software.amazon.awssdk.services.lightsail.model.AccessType.PRIVATE =>
      val r = `private`
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessType =
      software.amazon.awssdk.services.lightsail.model.AccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object public extends zio.aws.lightsail.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessType =
      software.amazon.awssdk.services.lightsail.model.AccessType.PUBLIC
  }
  case object `private` extends zio.aws.lightsail.model.AccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessType =
      software.amazon.awssdk.services.lightsail.model.AccessType.PRIVATE
  }
}
