package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait AccountLevelBpaSyncStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus
}
object AccountLevelBpaSyncStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus
  ): zio.aws.lightsail.model.AccountLevelBpaSyncStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.IN_SYNC =>
      val r = InSync
      r
    case software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.NEVER_SYNCED =>
      val r = NeverSynced
      r
    case software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.DEFAULTED =>
      val r = Defaulted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.AccountLevelBpaSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus =
      software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InSync extends zio.aws.lightsail.model.AccountLevelBpaSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus =
      software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.IN_SYNC
  }
  case object Failed extends zio.aws.lightsail.model.AccountLevelBpaSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus =
      software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.FAILED
  }
  case object NeverSynced
      extends zio.aws.lightsail.model.AccountLevelBpaSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus =
      software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.NEVER_SYNCED
  }
  case object Defaulted
      extends zio.aws.lightsail.model.AccountLevelBpaSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus =
      software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSyncStatus.DEFAULTED
  }
}
