package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait CertificateDomainValidationStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus
}
object CertificateDomainValidationStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus
  ): zio.aws.lightsail.model.CertificateDomainValidationStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.SUCCESS =>
      val r = SUCCESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.CertificateDomainValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus =
      software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_VALIDATION
      extends zio.aws.lightsail.model.CertificateDomainValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus =
      software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.PENDING_VALIDATION
  }
  case object FAILED
      extends zio.aws.lightsail.model.CertificateDomainValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus =
      software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.FAILED
  }
  case object SUCCESS
      extends zio.aws.lightsail.model.CertificateDomainValidationStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus =
      software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus.SUCCESS
  }
}
