package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudFormationStackRecordSourceInfo(
    resourceType: Optional[
      zio.aws.lightsail.model.CloudFormationStackRecordSourceType
    ] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo = {
    import CloudFormationStackRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly =
    zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo
      .wrap(buildAwsValue())
}
object CloudFormationStackRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo =
      zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo(
        resourceType.map(value => value),
        name.map(value => value),
        arn.map(value => value)
      )
    def resourceType
        : Optional[zio.aws.lightsail.model.CloudFormationStackRecordSourceType]
    def name: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.CloudFormationStackRecordSourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ) extends zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly {
    override val resourceType: Optional[
      zio.aws.lightsail.model.CloudFormationStackRecordSourceType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value =>
        zio.aws.lightsail.model.CloudFormationStackRecordSourceType.wrap(value)
      )
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ): zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly =
    new Wrapper(impl)
}
