package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait ContactMethodVerificationProtocol {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol
}
object ContactMethodVerificationProtocol {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol
  ): zio.aws.lightsail.model.ContactMethodVerificationProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.EMAIL =>
      val r = Email
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ContactMethodVerificationProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol =
      software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object Email
      extends zio.aws.lightsail.model.ContactMethodVerificationProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol =
      software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.EMAIL
  }
}
