package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class ContainerImage(
    image: Optional[String] = Optional.Absent,
    digest: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerImage = {
    import ContainerImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerImage
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(digest.map(value => value: java.lang.String))(_.digest)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerImage.ReadOnly =
    zio.aws.lightsail.model.ContainerImage.wrap(buildAwsValue())
}
object ContainerImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerImage =
      zio.aws.lightsail.model.ContainerImage(
        image.map(value => value),
        digest.map(value => value),
        createdAt.map(value => value)
      )
    def image: Optional[String]
    def digest: Optional[String]
    def createdAt: Optional[IsoDate]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getDigest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("digest", digest)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerImage
  ) extends zio.aws.lightsail.model.ContainerImage.ReadOnly {
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val digest: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.digest())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerImage
  ): zio.aws.lightsail.model.ContainerImage.ReadOnly = new Wrapper(impl)
}
