package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerServiceECRImagePullerRoleRequest(
    isActive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRoleRequest = {
    import ContainerServiceECRImagePullerRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRoleRequest
      .builder()
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest
      .wrap(buildAwsValue())
}
object ContainerServiceECRImagePullerRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest =
      zio.aws.lightsail.model
        .ContainerServiceECRImagePullerRoleRequest(isActive.map(value => value))
    def isActive: Optional[Boolean]
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRoleRequest
  ) extends zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest.ReadOnly {
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRoleRequest
  ): zio.aws.lightsail.model.ContainerServiceECRImagePullerRoleRequest.ReadOnly =
    new Wrapper(impl)
}
