package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAlarmRequest(alarmName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest = {
    import DeleteAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
      .builder()
      .alarmName(ResourceName.unwrap(alarmName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteAlarmRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteAlarmRequest.wrap(buildAwsValue())
}
object DeleteAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteAlarmRequest =
      zio.aws.lightsail.model.DeleteAlarmRequest(alarmName)
    def alarmName: ResourceName
    def getAlarmName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(alarmName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
  ) extends zio.aws.lightsail.model.DeleteAlarmRequest.ReadOnly {
    override val alarmName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.alarmName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest
  ): zio.aws.lightsail.model.DeleteAlarmRequest.ReadOnly = new Wrapper(impl)
}
