package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DestinationInfo(
    id: Optional[NonEmptyString] = Optional.Absent,
    service: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DestinationInfo = {
    import DestinationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DestinationInfo
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        service.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.service)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DestinationInfo.ReadOnly =
    zio.aws.lightsail.model.DestinationInfo.wrap(buildAwsValue())
}
object DestinationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DestinationInfo =
      zio.aws.lightsail.model
        .DestinationInfo(id.map(value => value), service.map(value => value))
    def id: Optional[NonEmptyString]
    def service: Optional[NonEmptyString]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getService: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ) extends zio.aws.lightsail.model.DestinationInfo.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val service: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.service())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ): zio.aws.lightsail.model.DestinationInfo.ReadOnly = new Wrapper(impl)
}
