package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetachStaticIpResponse(
    operations: Optional[Iterable[zio.aws.lightsail.model.Operation]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse = {
    import DetachStaticIpResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly =
    zio.aws.lightsail.model.DetachStaticIpResponse.wrap(buildAwsValue())
}
object DetachStaticIpResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DetachStaticIpResponse =
      zio.aws.lightsail.model.DetachStaticIpResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operations: Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse
  ) extends zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly {
    override val operations
        : Optional[List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Operation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse
  ): zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly = new Wrapper(impl)
}
