package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiskInfo(
    name: Optional[String] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    sizeInGb: Optional[Integer] = Optional.Absent,
    isSystemDisk: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskInfo = {
    import DiskInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskInfo
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(
        _.isSystemDisk
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DiskInfo.ReadOnly =
    zio.aws.lightsail.model.DiskInfo.wrap(buildAwsValue())
}
object DiskInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DiskInfo =
      zio.aws.lightsail.model.DiskInfo(
        name.map(value => value),
        path.map(value => value),
        sizeInGb.map(value => value),
        isSystemDisk.map(value => value)
      )
    def name: Optional[String]
    def path: Optional[NonEmptyString]
    def sizeInGb: Optional[Integer]
    def isSystemDisk: Optional[Boolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
    def getIsSystemDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSystemDisk", isSystemDisk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskInfo
  ) extends zio.aws.lightsail.model.DiskInfo.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val sizeInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInGb())
      .map(value => value: Integer)
    override val isSystemDisk: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSystemDisk())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskInfo
  ): zio.aws.lightsail.model.DiskInfo.ReadOnly = new Wrapper(impl)
}
