package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DistributionBundle(
    bundleId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    price: Optional[Float] = Optional.Absent,
    transferPerMonthInGb: Optional[Integer] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DistributionBundle = {
    import DistributionBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DistributionBundle
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DistributionBundle.ReadOnly =
    zio.aws.lightsail.model.DistributionBundle.wrap(buildAwsValue())
}
object DistributionBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DistributionBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DistributionBundle =
      zio.aws.lightsail.model.DistributionBundle(
        bundleId.map(value => value),
        name.map(value => value),
        price.map(value => value),
        transferPerMonthInGb.map(value => value),
        isActive.map(value => value)
      )
    def bundleId: Optional[String]
    def name: Optional[String]
    def price: Optional[Float]
    def transferPerMonthInGb: Optional[Integer]
    def isActive: Optional[Boolean]
    def getBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getTransferPerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGb)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DistributionBundle
  ) extends zio.aws.lightsail.model.DistributionBundle.ReadOnly {
    override val bundleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val price: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Float)
    override val transferPerMonthInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.transferPerMonthInGb())
      .map(value => value: Integer)
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DistributionBundle
  ): zio.aws.lightsail.model.DistributionBundle.ReadOnly = new Wrapper(impl)
}
