package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait DnsRecordCreationStateCode {
  def unwrap: software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode
}
object DnsRecordCreationStateCode {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode
  ): zio.aws.lightsail.model.DnsRecordCreationStateCode = value match {
    case software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.DnsRecordCreationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode =
      software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED
      extends zio.aws.lightsail.model.DnsRecordCreationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode =
      software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.SUCCEEDED
  }
  case object STARTED
      extends zio.aws.lightsail.model.DnsRecordCreationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode =
      software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.STARTED
  }
  case object FAILED
      extends zio.aws.lightsail.model.DnsRecordCreationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode =
      software.amazon.awssdk.services.lightsail.model.DnsRecordCreationStateCode.FAILED
  }
}
