package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerImagesResponse(
    containerImages: Optional[
      Iterable[zio.aws.lightsail.model.ContainerImage]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse = {
    import GetContainerImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
      .builder()
      .optionallyWith(
        containerImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerImages)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerImagesResponse.wrap(buildAwsValue())
}
object GetContainerImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerImagesResponse =
      zio.aws.lightsail.model.GetContainerImagesResponse(
        containerImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerImages
        : Optional[List[zio.aws.lightsail.model.ContainerImage.ReadOnly]]
    def getContainerImages: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ContainerImage.ReadOnly
    ]] = AwsError.unwrapOptionField("containerImages", containerImages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
  ) extends zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly {
    override val containerImages
        : Optional[List[zio.aws.lightsail.model.ContainerImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.ContainerImage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
  ): zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
