package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, ContainerServiceName}
import scala.jdk.CollectionConverters._
final case class GetContainerLogRequest(
    serviceName: ContainerServiceName,
    containerName: String,
    startTime: Optional[IsoDate] = Optional.Absent,
    endTime: Optional[IsoDate] = Optional.Absent,
    filterPattern: Optional[String] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest = {
    import GetContainerLogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .containerName(containerName: java.lang.String)
      .optionallyWith(startTime.map(value => IsoDate.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => IsoDate.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(filterPattern.map(value => value: java.lang.String))(
        _.filterPattern
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetContainerLogRequest.ReadOnly =
    zio.aws.lightsail.model.GetContainerLogRequest.wrap(buildAwsValue())
}
object GetContainerLogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerLogRequest =
      zio.aws.lightsail.model.GetContainerLogRequest(
        serviceName,
        containerName,
        startTime.map(value => value),
        endTime.map(value => value),
        filterPattern.map(value => value),
        pageToken.map(value => value)
      )
    def serviceName: ContainerServiceName
    def containerName: String
    def startTime: Optional[IsoDate]
    def endTime: Optional[IsoDate]
    def filterPattern: Optional[String]
    def pageToken: Optional[String]
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getContainerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerName)
    def getStartTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getFilterPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filterPattern", filterPattern)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
  ) extends zio.aws.lightsail.model.GetContainerLogRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val containerName: String = impl.containerName(): String
    override val startTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val endTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val filterPattern: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.filterPattern())
      .map(value => value: String)
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
  ): zio.aws.lightsail.model.GetContainerLogRequest.ReadOnly = new Wrapper(impl)
}
