package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetContainerServiceDeploymentsRequest(
    serviceName: ContainerServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest = {
    import GetContainerServiceDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerServiceDeploymentsRequest.ReadOnly =
    zio.aws.lightsail.model.GetContainerServiceDeploymentsRequest
      .wrap(buildAwsValue())
}
object GetContainerServiceDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetContainerServiceDeploymentsRequest =
      zio.aws.lightsail.model.GetContainerServiceDeploymentsRequest(serviceName)
    def serviceName: ContainerServiceName
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
  ) extends zio.aws.lightsail.model.GetContainerServiceDeploymentsRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
  ): zio.aws.lightsail.model.GetContainerServiceDeploymentsRequest.ReadOnly =
    new Wrapper(impl)
}
