package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerServiceDeploymentsResponse(
    deployments: Optional[
      Iterable[zio.aws.lightsail.model.ContainerServiceDeployment]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse = {
    import GetContainerServiceDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
      .builder()
      .optionallyWith(
        deployments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployments)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse
      .wrap(buildAwsValue())
}
object GetContainerServiceDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse =
      zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse(
        deployments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deployments: Optional[
      List[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly]
    ]
    def getDeployments: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ]] = AwsError.unwrapOptionField("deployments", deployments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
  ) extends zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly {
    override val deployments: Optional[
      List[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deployments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ContainerServiceDeployment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
  ): zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly =
    new Wrapper(impl)
}
