package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerServicesResponse(
    containerServices: Optional[
      Iterable[zio.aws.lightsail.model.ContainerService]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse = {
    import GetContainerServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
      .builder()
      .optionallyWith(
        containerServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerServices)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerServicesResponse.wrap(buildAwsValue())
}
object GetContainerServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerServicesResponse =
      zio.aws.lightsail.model.GetContainerServicesResponse(
        containerServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerServices
        : Optional[List[zio.aws.lightsail.model.ContainerService.ReadOnly]]
    def getContainerServices: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ContainerService.ReadOnly
    ]] = AwsError.unwrapOptionField("containerServices", containerServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
  ) extends zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly {
    override val containerServices
        : Optional[List[zio.aws.lightsail.model.ContainerService.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.ContainerService.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse
  ): zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly =
    new Wrapper(impl)
}
