package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDiskRequest(diskName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskRequest = {
    import GetDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDiskRequest.ReadOnly =
    zio.aws.lightsail.model.GetDiskRequest.wrap(buildAwsValue())
}
object GetDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDiskRequest =
      zio.aws.lightsail.model.GetDiskRequest(diskName)
    def diskName: ResourceName
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskRequest
  ) extends zio.aws.lightsail.model.GetDiskRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskRequest
  ): zio.aws.lightsail.model.GetDiskRequest.ReadOnly = new Wrapper(impl)
}
