package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDistributionsResponse(
    distributions: Optional[
      Iterable[zio.aws.lightsail.model.LightsailDistribution]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse = {
    import GetDistributionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
      .builder()
      .optionallyWith(
        distributions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.distributions)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly =
    zio.aws.lightsail.model.GetDistributionsResponse.wrap(buildAwsValue())
}
object GetDistributionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetDistributionsResponse =
      zio.aws.lightsail.model.GetDistributionsResponse(
        distributions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def distributions
        : Optional[List[zio.aws.lightsail.model.LightsailDistribution.ReadOnly]]
    def nextPageToken: Optional[String]
    def getDistributions: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LightsailDistribution.ReadOnly
    ]] = AwsError.unwrapOptionField("distributions", distributions)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
  ) extends zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly {
    override val distributions: Optional[
      List[zio.aws.lightsail.model.LightsailDistribution.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.distributions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LightsailDistribution.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
  ): zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
