package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInstanceMetricDataResponse(
    metricName: Optional[zio.aws.lightsail.model.InstanceMetricName] =
      Optional.Absent,
    metricData: Optional[Iterable[zio.aws.lightsail.model.MetricDatapoint]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse = {
    import GetInstanceMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly =
    zio.aws.lightsail.model.GetInstanceMetricDataResponse.wrap(buildAwsValue())
}
object GetInstanceMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetInstanceMetricDataResponse =
      zio.aws.lightsail.model.GetInstanceMetricDataResponse(
        metricName.map(value => value),
        metricData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Optional[zio.aws.lightsail.model.InstanceMetricName]
    def metricData
        : Optional[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]]
    def getMetricName
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricData: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
  ) extends zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly {
    override val metricName
        : Optional[zio.aws.lightsail.model.InstanceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value => zio.aws.lightsail.model.InstanceMetricName.wrap(value))
    override val metricData
        : Optional[List[zio.aws.lightsail.model.MetricDatapoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.MetricDatapoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse
  ): zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
