package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLoadBalancerTlsCertificatesRequest(
    loadBalancerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest = {
    import GetLoadBalancerTlsCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesRequest.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesRequest
      .wrap(buildAwsValue())
}
object GetLoadBalancerTlsCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesRequest =
      zio.aws.lightsail.model
        .GetLoadBalancerTlsCertificatesRequest(loadBalancerName)
    def loadBalancerName: ResourceName
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
  ) extends zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
  ): zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
