package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLoadBalancerTlsPoliciesResponse(
    tlsPolicies: Optional[
      Iterable[zio.aws.lightsail.model.LoadBalancerTlsPolicy]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse = {
    import GetLoadBalancerTlsPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse
      .builder()
      .optionallyWith(
        tlsPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsPolicies)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly =
    zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancerTlsPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse =
      zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse(
        tlsPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def tlsPolicies
        : Optional[List[zio.aws.lightsail.model.LoadBalancerTlsPolicy.ReadOnly]]
    def nextPageToken: Optional[String]
    def getTlsPolicies: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("tlsPolicies", tlsPolicies)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse
  ) extends zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly {
    override val tlsPolicies: Optional[
      List[zio.aws.lightsail.model.LoadBalancerTlsPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsPolicy.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse
  ): zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
