package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseEventsResponse(
    relationalDatabaseEvents: Optional[
      Iterable[zio.aws.lightsail.model.RelationalDatabaseEvent]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse = {
    import GetRelationalDatabaseEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
      .builder()
      .optionallyWith(
        relationalDatabaseEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabaseEvents)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse(
        relationalDatabaseEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def relationalDatabaseEvents: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly]
    ]
    def nextPageToken: Optional[String]
    def getRelationalDatabaseEvents: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabaseEvents",
      relationalDatabaseEvents
    )
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly {
    override val relationalDatabaseEvents: Optional[
      List[zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationalDatabaseEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.RelationalDatabaseEvent.wrap(item)
        }.toList
      )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly =
    new Wrapper(impl)
}
