package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRelationalDatabaseLogStreamsRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest = {
    import GetRelationalDatabaseLogStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsRequest =
      zio.aws.lightsail.model
        .GetRelationalDatabaseLogStreamsRequest(relationalDatabaseName)
    def relationalDatabaseName: ResourceName
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsRequest.ReadOnly =
    new Wrapper(impl)
}
