package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait HttpEndpoint {
  def unwrap: software.amazon.awssdk.services.lightsail.model.HttpEndpoint
}
object HttpEndpoint {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.HttpEndpoint
  ): zio.aws.lightsail.model.HttpEndpoint = value match {
    case software.amazon.awssdk.services.lightsail.model.HttpEndpoint.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.HttpEndpoint.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.lightsail.model.HttpEndpoint.ENABLED =>
      val r = enabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.HttpEndpoint {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpEndpoint =
      software.amazon.awssdk.services.lightsail.model.HttpEndpoint.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.lightsail.model.HttpEndpoint {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpEndpoint =
      software.amazon.awssdk.services.lightsail.model.HttpEndpoint.DISABLED
  }
  case object enabled extends zio.aws.lightsail.model.HttpEndpoint {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpEndpoint =
      software.amazon.awssdk.services.lightsail.model.HttpEndpoint.ENABLED
  }
}
