package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait HttpProtocolIpv6 {
  def unwrap: software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6
}
object HttpProtocolIpv6 {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6
  ): zio.aws.lightsail.model.HttpProtocolIpv6 = value match {
    case software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6.ENABLED =>
      val r = enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.HttpProtocolIpv6 {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6 =
      software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.lightsail.model.HttpProtocolIpv6 {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6 =
      software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6.DISABLED
  }
  case object enabled extends zio.aws.lightsail.model.HttpProtocolIpv6 {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6 =
      software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6.ENABLED
  }
}
