package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{ResourceName, IpAddress, IsoDate}
import scala.jdk.CollectionConverters._
final case class InstanceAccessDetails(
    certKey: Optional[String] = Optional.Absent,
    expiresAt: Optional[IsoDate] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    password: Optional[String] = Optional.Absent,
    passwordData: Optional[zio.aws.lightsail.model.PasswordData] =
      Optional.Absent,
    privateKey: Optional[String] = Optional.Absent,
    protocol: Optional[zio.aws.lightsail.model.InstanceAccessProtocol] =
      Optional.Absent,
    instanceName: Optional[ResourceName] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    hostKeys: Optional[Iterable[zio.aws.lightsail.model.HostKeyAttributes]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails = {
    import InstanceAccessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
      .builder()
      .optionallyWith(certKey.map(value => value: java.lang.String))(_.certKey)
      .optionallyWith(expiresAt.map(value => IsoDate.unwrap(value): Instant))(
        _.expiresAt
      )
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(passwordData.map(value => value.buildAwsValue()))(
        _.passwordData
      )
      .optionallyWith(privateKey.map(value => value: java.lang.String))(
        _.privateKey
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        instanceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        hostKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hostKeys)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly =
    zio.aws.lightsail.model.InstanceAccessDetails.wrap(buildAwsValue())
}
object InstanceAccessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceAccessDetails =
      zio.aws.lightsail.model.InstanceAccessDetails(
        certKey.map(value => value),
        expiresAt.map(value => value),
        ipAddress.map(value => value),
        password.map(value => value),
        passwordData.map(value => value.asEditable),
        privateKey.map(value => value),
        protocol.map(value => value),
        instanceName.map(value => value),
        username.map(value => value),
        hostKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certKey: Optional[String]
    def expiresAt: Optional[IsoDate]
    def ipAddress: Optional[IpAddress]
    def password: Optional[String]
    def passwordData: Optional[zio.aws.lightsail.model.PasswordData.ReadOnly]
    def privateKey: Optional[String]
    def protocol: Optional[zio.aws.lightsail.model.InstanceAccessProtocol]
    def instanceName: Optional[ResourceName]
    def username: Optional[String]
    def hostKeys
        : Optional[List[zio.aws.lightsail.model.HostKeyAttributes.ReadOnly]]
    def getCertKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certKey", certKey)
    def getExpiresAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("password", password)
    def getPasswordData
        : ZIO[Any, AwsError, zio.aws.lightsail.model.PasswordData.ReadOnly] =
      AwsError.unwrapOptionField("passwordData", passwordData)
    def getPrivateKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceAccessProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getHostKeys: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.HostKeyAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("hostKeys", hostKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ) extends zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly {
    override val certKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certKey())
      .map(value => value: String)
    override val expiresAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val password: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => value: String)
    override val passwordData
        : Optional[zio.aws.lightsail.model.PasswordData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordData())
        .map(value => zio.aws.lightsail.model.PasswordData.wrap(value))
    override val privateKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKey())
      .map(value => value: String)
    override val protocol
        : Optional[zio.aws.lightsail.model.InstanceAccessProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.lightsail.model.InstanceAccessProtocol.wrap(value)
        )
    override val instanceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val hostKeys
        : Optional[List[zio.aws.lightsail.model.HostKeyAttributes.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.HostKeyAttributes.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ): zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly = new Wrapper(impl)
}
