package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait InstanceMetadataState {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.InstanceMetadataState
}
object InstanceMetadataState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstanceMetadataState
  ): zio.aws.lightsail.model.InstanceMetadataState = value match {
    case software.amazon.awssdk.services.lightsail.model.InstanceMetadataState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetadataState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceMetadataState.APPLIED =>
      val r = applied
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.InstanceMetadataState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetadataState =
      software.amazon.awssdk.services.lightsail.model.InstanceMetadataState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.lightsail.model.InstanceMetadataState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetadataState =
      software.amazon.awssdk.services.lightsail.model.InstanceMetadataState.PENDING
  }
  case object applied extends zio.aws.lightsail.model.InstanceMetadataState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceMetadataState =
      software.amazon.awssdk.services.lightsail.model.InstanceMetadataState.APPLIED
  }
}
