package zio.aws.lightsail.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.Port
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstancePortState(
    fromPort: Optional[Port] = Optional.Absent,
    toPort: Optional[Port] = Optional.Absent,
    protocol: Optional[zio.aws.lightsail.model.NetworkProtocol] =
      Optional.Absent,
    state: Optional[zio.aws.lightsail.model.PortState] = Optional.Absent,
    cidrs: Optional[Iterable[String]] = Optional.Absent,
    ipv6Cidrs: Optional[Iterable[String]] = Optional.Absent,
    cidrListAliases: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstancePortState = {
    import InstancePortState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortState
      .builder()
      .optionallyWith(fromPort.map(value => Port.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => Port.unwrap(value): Integer))(
        _.toPort
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ipv6Cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Cidrs)
      .optionallyWith(
        cidrListAliases.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrListAliases)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstancePortState.ReadOnly =
    zio.aws.lightsail.model.InstancePortState.wrap(buildAwsValue())
}
object InstancePortState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstancePortState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstancePortState =
      zio.aws.lightsail.model.InstancePortState(
        fromPort.map(value => value),
        toPort.map(value => value),
        protocol.map(value => value),
        state.map(value => value),
        cidrs.map(value => value),
        ipv6Cidrs.map(value => value),
        cidrListAliases.map(value => value)
      )
    def fromPort: Optional[Port]
    def toPort: Optional[Port]
    def protocol: Optional[zio.aws.lightsail.model.NetworkProtocol]
    def state: Optional[zio.aws.lightsail.model.PortState]
    def cidrs: Optional[List[String]]
    def ipv6Cidrs: Optional[List[String]]
    def cidrListAliases: Optional[List[String]]
    def getFromPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.NetworkProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.PortState] =
      AwsError.unwrapOptionField("state", state)
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getIpv6Cidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Cidrs", ipv6Cidrs)
    def getCidrListAliases: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrListAliases", cidrListAliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortState
  ) extends zio.aws.lightsail.model.InstancePortState.ReadOnly {
    override val fromPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val toPort: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val protocol: Optional[zio.aws.lightsail.model.NetworkProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.lightsail.model.NetworkProtocol.wrap(value))
    override val state: Optional[zio.aws.lightsail.model.PortState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.PortState.wrap(value))
    override val cidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv6Cidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cidrListAliases: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrListAliases())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortState
  ): zio.aws.lightsail.model.InstancePortState.ReadOnly = new Wrapper(impl)
}
