package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoadBalancerTlsCertificateDnsRecordCreationState(
    code: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationStateCode
    ] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState = {
    import LoadBalancerTlsCertificateDnsRecordCreationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDnsRecordCreationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState =
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationStateCode
    ]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationStateCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState.ReadOnly {
    override val code: Optional[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationStateCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationStateCode
          .wrap(value)
      )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState.ReadOnly =
    new Wrapper(impl)
}
